  subroutine rdclapp_ice(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=4000,nt=9
  integer :: i,itemp
  real :: diff,diffmin
! Note that the ndat,nt is opposite to the ncdump dump
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat),rival(ndat)
  real :: tk(nt)
  character(len=60) :: fil
  character(len=60) :: files(nt)
  character (len=16) :: llset

! Added for ascii read
  character(len=80) :: header
  integer :: nlinesw(nt)

  integer :: numlines(nt)
  data numlines/3321, 3322, 3322, 3320, 3318, 3314, 3320, 3320, 3320 /

! ***
! Will specify which temperature to work with

  write(0,fmt=140)
  140 format(2x,"Specify temp ( 130, 140, 150, 160, 170, 180, 190, 200, 210 K ")

  write(0,fmt=160)
  160 format(2x,"Specify temp in K ")

  read(5,*) temp

  do i=1,nt
   tk(i)=130.0+((i-1)*10.0)
  end do

   diffmin=1.0e6
  do i=1,nt
    diff=abs(temp-tk(i))
   if (diff .le. diffmin) then
    itemp=i
    diffmin=diff
   endif
  end do

! The compound string
!       '1234567890123456'
  llset=' CLAPP Ice      '

  write(0,fmt=170) itemp,tk(itemp),llset
  write(iout,fmt=170) itemp,tk(itemp),llset
  170 format(2x," itemp,tk(itemp),llset ",i4,2x,f10.4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii files
!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='clapp_ice/ice130.clapp                                      '
  files(2)='clapp_ice/ice140.clapp                                      '
  files(3)='clapp_ice/ice150.clapp                                      '
  files(4)='clapp_ice/ice160.clapp                                      '
  files(5)='clapp_ice/ice170.clapp                                      '
  files(6)='clapp_ice/ice180.clapp                                      '
  files(7)='clapp_ice/ice190.clapp                                      '
  files(8)='clapp_ice/ice200.clapp                                      '
  files(9)='clapp_ice/ice210.clapp                                      '

! Obtain the full pathname of the input ascii file
  fil=files(itemp)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of water ice at 150K from
!  800 to 4004 cm-1.
!
!  Reference: Clapp, M. L., R. E. Miller, and D. R. Worsnop,
!  Frequency-Dependent Optical Constants of Water Ice Obtained
!  Directly from Aerosol Extinction Spectra, J. Phys. Chem.,
!  volume 99, pgs. 6317-6326, 1995.
!
!  Email contact person: R. E. Miller (remiller@unc.edu)
!
!  Format: 3318 lines (2x,f7.2,2x,f10.4,2x,f5.3,2x,1p,e10.3)
!
!   cm-1       microns  real    imaginary
!   800.36     12.4944  1.613   4.032E-01
!   801.33     12.4793  1.611   4.062E-01

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  nlines=numlines(itemp)

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
   700 format(2x,i4,1p,9(1x,e10.3))
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=200) nlines,fil
    200 format(/,2x,"rdclapp_ice: nlines,fil",/,&
    2x,i4,2x,a60)
    write(iout,fmt=170) itemp,tk(itemp),llset
    write(iout,fmt=840)
    840 format(/,2x,"rdclapp_ice: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
