  subroutine rdindices(noprind,iout,&
  indir,iset,nsets,listrn,lstrn,&
  nlines,wcm,wavelength,rndat,ridat,&
  outdir,iwave,iwrind,lset,llset,ibothpos,ndifferent)

! *************************
! Has max number of output wavelengths (or indices)
  include 'param1.inc'

! See rdinoutdir.f90
  character(len=60) :: indir,outdir

! See rdwork.f90
  integer :: noprind,iout,nopr
  integer :: itest,iset,iwrind
  integer :: iwave

  integer :: nlines

! See rdlistrn.f90
  integer :: nsets
  integer,parameter :: nfmax=100
  character(len=100) :: listrn(nfmax)
  character(len=100) :: lstrn

! See rdindices.f90
  integer :: ibothpos
  character(len=100) :: lset
  integer :: nlinesr,nlinesi
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)

! For cases in which the number of real and imaginary indices differ
  real :: wcmr(nwavemax),wavelengthr(nwavemax)
  real :: wcmi(nwavemax),wavelengthi(nwavemax)

! **
! Used here
  integer :: ione,ndiferent,ifound,mn
  character(len=100) :: filnm
  character(len=16) :: llset

! *************************
! Will set ibothpos=1 if you specify real and imaginary
! Some sets have only e.g. imaginary indices (Kou)
! For these cases, set ibothpos=0
   ibothpos=1

! If the number of real and imaginary indices are different, then
! ndifferent=1
   ndifferent=0

! If the data set only has one value put ione=1
   ione=0

   nopr=noprind

! *************************
! The set to work with
! Notice that you specify iset+1 for 1 based fortran
   lstrn=listrn(iset+1)

! *************************
  if (nopr .eq. 1) then
   write(iout,fmt=200)
   200 format(/)
   write(iout,fmt=210) iset
   210 format(2x,"  rdindices: iset ",/,2x,i4)
   write(iout,fmt=220) lstrn
   220 format(2x,"  rdindices: lstrn ",/,2x,a100)
  end if

! *************************
! The iset and numbers here must be corrdinated with the   indices.dat   files
! e.g. Tisdale h2so4 indices are the first index set. Note that
! IDL is 0 based so that e.g. vec(0) is the first element in the vector vec.

  ifound=-1

! **
! Read in the AFCRL 1987 indices compiled by Eric Shettle
  if (iset .eq. 0) then 
   call rdshettle(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Downing and Williams water indices
  if (iset .eq. 1) then 
   call rddowning(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Wagner supercooled indices
  if (iset .eq. 2) then 
   call rdwagner_supercooled(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Warren ice indices
  if (iset .eq. 3) then 
   call rdwarren_ice(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Clapp ice indices
  if (iset .eq. 4) then 
   call rdclapp_ice(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Tisdale cold temperature h2so4 indices
  if (iset .eq. 5) then 
   call rdtisdale(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Myhre h2so4 indices
  if (iset .eq. 6) then 
   call rdmyhre_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Myhre hno3 values
  if (iset .eq. 7) then 
   call rdmyhre_hno3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Myhre ternary indices
  if (iset .eq. 8) then 
   call rdmyhre_ternary(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Niedziela nad indices
  if (iset .eq. 9) then 
   call rdniedziela_nad(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Richwine nat indices
  if (iset .eq. 10) then 
   call rdrichwine_nat(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Toon psc indices
  if (iset .eq. 11) then 
   call rdtoon_psc(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Wagner sahara dust indices
  if (iset .eq. 12) then 
   call rdwagner_sahara_dust(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Grainger volcanic ash indices
  if (iset .eq. 13) then 
   call rdgrainger_volcanic_ash(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! Read in the Deguine volcanic ash indices
  if (iset .eq. 14) then 
   call rddeguine_ash(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Liu SOA ACP
  if (iset .eq. 15) then 
    ndifferent=1
   call rdliu_soa_acp(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat,&
   ndifferent,iwave)
   ifound=1

! Put data into same wavelength grid
   call samewave(nopr,iout,&
   nlines,wcm,wavelength,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat)
  end if

! **
! Read in the Liu SOA EST
  if (iset .eq. 16) then 
   call rdliu_soa_est(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Myhre organic acids
  if (iset .eq. 17) then 
   call rdmyhre_organic_acids(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Alexander brown carbon
  if (iset .eq. 18) then 
   call rdalexander_brown_carbon(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Sutherland Khanna burning vegetation indices
  if (iset .eq. 19) then 
   call rdsutherland_khanna(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Magi biomass fire indices
  if (iset .eq. 20) then 
   call rdmagi_biomass_fire(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Stagg carbon indices
  if (iset .eq. 21) then 
   call rdstagg_carbon(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Chang flame soot
  if (iset .eq. 22) then 
   call rdchang_flame_soot(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Querry mineral indices
  if (iset .eq. 23) then 
   call rdquerry_minerals(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Toon mineral indices
  if (iset .eq. 24) then 
   call rdtoon_minerals(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Khare Titan Tholins
  if (iset .eq. 25) then 
   call rdkhare_titan_tholins(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Ramirez Titan Aerosol
  if (iset .eq. 26) then 
   call rdramirez_titan_aerosol(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Imanaka Tian tholins
  if (iset .eq. 27) then 
   call rd_imanaka(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Querry KCl
  if (iset .eq. 28) then 
   call rdquerry_kcl(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Querry ZnS
  if (iset .eq. 29) then 
   call rdquerry_zns(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Henning Mutschke SiO2 (low temperature)
  if (iset .eq. 30) then 
   call rdhenning_sio2_lowtemp(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Zeidler SiO2 (high temperature)
  if (iset .eq. 31) then 
   call rdzeidler_sio2_hightemp(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Begemann Al2O3 (porous and compact)
  if (iset .eq. 32) then 
   call rdbegemann_al2o3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Henning FeO
  if (iset .eq. 33) then 
   call rdhenning_feo(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Posch CaTiO3
  if (iset .eq. 34) then 
   call rdposch_catio3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Triaud F22O3
  if (iset .eq. 35) then 
   call rdtriaud_fe2o3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Jena (unpublished) Fe2SIO4, visible
  if (iset .eq. 36) then 
   call rdjena_fe2sio4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Fabian Fe2SiO4, mid and far IR
  if (iset .eq. 37) then 
   call rdfabian_fe2sio4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Fabian MgAl2O4 (natural and annealed) 
  if (iset .eq. 38) then 
   call rdfabian_mgal2o4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Jager Mg2SiO4
  if (iset .eq. 39) then 
   call rdjager_mg2sio4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Jager SiO3
  if (iset .eq. 40) then 
   call rdjager_mgsio3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Zeidler TiO2 (Rutile; ordinary and extraordinary rays)
  if (iset .eq. 41) then 
   call rdzeidler_tio2_rutile(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Zeidler TiO2 (Anatase; ab and c rays)
  if (iset .eq. 42) then 
   call rdzeidler_tio2_anatase(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **
! Read in the Posch TiO2 (Brookite; x,y,z rays)
  if (iset .eq. 43) then 
   call rdposch_tio2_brookite(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if
 
! **********************************
! new indices  will renumber here and    indices.dat   when all new indices have
! been obtained   Will renumber (place) indices according to natural groupin

! **
! *************************
! Supplementary 

! **
! Read in the Kou imaginary indices for water and ice
! Note that the real refractive indices are 0.0
  if (iset .eq. 44) then 
   call rdkou(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   ibothpos=0
   write(iout,fmt=190)
   190 format(2x," rdindices: only kou imaginiary indices given, will stop")
   write(0,fmt=190)
   stop
   go to 1000
  end if

! **
! Read in the Sinyuk (and Patterson) saharan dust imaginary indices
  if (iset .eq. 45) then 
   call rdsinyuk_saharan_dust(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   ibothpos=0
   go to 1000
  end if

! **
! Read in the Dingle SOA
  if (iset .eq. 46) then 
   call rddingle_soa(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Zarana (and others) index of soa (lab proxy) at 532 nm
  if (iset .eq. 47) then 
   call rdzarzana_soa(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   ione=1
   go to 1000
  end if

! **
! Read in the Querry diesel soot
  if (iset .eq. 48) then 
   call rdquerry_diesel_soot(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Niedziela h2so4 indices
  if (iset .eq. 49) then 
   call rdniedziela_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Biermann h2so4 indices
  if (iset .eq. 50) then 
    ndifferent=1
   call rdbiermann_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat,&
   ndifferent,iwave)
   ifound=1

! Put data into same wavelength grid
   call samewave(nopr,iout,&
   nlines,wcm,wavelength,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat)

   go to 1000
  end if

! **
! Read in the Palmer_Williams_h2so4 indices
  if (iset .eq. 51) then 
   call rdpalmer_williams_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Norman hno3 indices
  if (iset .eq. 52) then 
   call rdnorman_hno3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Biermann hno3 indices
  if (iset .eq. 53) then 
    ndifferent=1
   call rdbiermann_hno3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat,&
   ndifferent,iwave)
   ifound=1

! Put data into same wavelength grid
   call samewave(nopr,iout,&
   nlines,wcm,wavelength,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat)
   go to 1000
  end if

! **
! Read in the Querry_Tyler hno3 h2o indices
  if (iset .eq. 54) then 
   call rdquerry_tyler_hno3_h2o(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Remsberg h2so4 hno3 indices
  if (iset .eq. 55) then 
   call rdremsberg_h2so4_hno3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   go to 1000
  end if

! **
! Read in the Hasenkopf (and others) organic haze index at 532 nm
  if (iset .eq. 56) then 
   call rdhasenkopf_organic_haze(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)
   ifound=1
   ione=1
   go to 1000
  end if

! *************************
  1000 mn=0

  if (ifound .ne. 1) then 
   write(0,fmt=2000)
   2000 format(2x," rdindices: ifound .ne. 1, will stop")
   stop
  end if

! *************************
! Write out the original indices 
  if (iwrind .eq. 1) then 
   call wrindices_orig(nopr,iout,outdir,&
   nlines,wcm,wavelength,rndat,ridat,iwave,&
   lset)
  end if

! *************************
  return
  end
