  subroutine rdalexander_brown_carbon(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=501
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/alexander_brown_carbon.dat                     '

!       '1234567890123456'
  llset=' Brown Carbon   '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if


! Data: Real and imaginary indices of brown carbon spheres measured
! during the Asian Pacific Regional Aerosol Characterization Experiment
! (ACE-Asia). Complex dielectric constants are also tabulated.

! Reference: Duncan. T. Alexander, Peter A. Crozier, James R. Anderson
! Brown Carbon Spheres in East Asian Outflow and Their Optical
! Properties, Science, vol 321, 8 August 2008

! Contact: Peter Crozier (crozier@asu.edu)

! Format: 501 lines 2x,2(1x,f9.3),2(1x,f10.4)

!      cm-1    microns     real     imaginary
!   50000.000     0.200     1.3722     0.3031
!   49504.949     0.202     1.3763     0.3057

! ***
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840)
    840 format(/,2x,"rdalexander_brown_carbon: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
