   subroutine rdkou(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ncomp=3
  integer :: i,ii
  integer,parameter :: ndat=5000
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

  integer :: nwater22,nwaterm8,nicem25
  real :: riwater22(ndat),riwaterm8(ndat),riwaterm25(ndat)
  real :: er1,er2,er3

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! Specify by hand (have code read in values)
!          '1234567890123456'
  files(1)='Water 22 C      '
  files(2)='Ice   -8 C      '
  files(3)='Ice  -25 C      '

  write(0,fmt=140)
  140 format(2x," Will select  mset  value for a specific compound")
  write(0,fmt=145)
  145 format(2x," mset, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-3) e.g. mset=1 for Water 22 C ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! Read in the data from the ascii file
   lset=lstrn
!       '1234567890123456'
   llset='kou_water_ice  '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/kou_water_ice.dat                              '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ******

! Data: Imaginary indices of refraction for water and ice in
! the 0.67 to 2.5 micron range.

! Reference: L. Kou, D. Labrie, and P. Chylek, Refractive indices of
! water and ice in the 0.65 to 2.5 micron range, Applied Optics,
! vol. 32, pgs. 3531-3540, 1993.

! Format: wavenumber (cm-1), wavelength (microns), imaginary index
! of refraction, error (percent)
! 147 values from  4000 to  6920 cm-1 (2x,f6.0,1x,f6.4,3(4x,e10.3,1x,f4.1))
! at 22 and -8 C for water, and at -25 C for ice.
! 186 values from  6940 to 10640 cm-1 (2x,f6.0,1x,f6.4,2(4x,e10.3,1x,f4.1))
! at 22 and -8 C for water.
! 218 values from 10660 to 15000 cm-1 (2x,f6.0,1x,f6.4,1(4x,e10.3,1x,f4.1))
! at 22 C for water.


!                   Water              Water              ICE
!                   22 C               -8 C               -25 C
!  cm-1  microns    imaginary  error   imaginary  error   imaginary  error

!  4000. 2.5000     2.000E-03  3.6     1.760E-03  4.3     8.040E-04  6.0
!  4020. 2.4876     1.870E-03  3.3     1.680E-03  4.1     7.720E-04  4.7
!  4040. 2.4752     1.710E-03  3.9     1.560E-03  4.3     7.440E-04  3.8
!  4060. 2.4631     1.560E-03  3.1     1.420E-03  3.8     7.200E-04  3.8
!  4080. 2.4510     1.400E-03  2.0     1.250E-03  3.0     6.910E-04  3.0
!21234561123456123412345678901123412341234567890112341234123456789011234

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

! Read in the data
   do i=1,22
    read(idat,fmt=100) header
   end do
   100 format(a80)

! ******
  nicem25=147
  nwaterm8=186
  nwater22=218

    i=0
   do ii=1,nicem25
    i=i+1
    read(idat,fmt=104) wcmdat(i),wavedat(i),riwater22(i),er1,riwaterm8(i),er2,&
     riwaterm25(i),er3
    104 format(2x,f6.0,1x,f6.4,3(4x,e10.3,1x,f4.1))
   end do

   do ii=1,nwaterm8
    i=i+1
    read(idat,fmt=106) wcmdat(i),wavedat(i),riwater22(i),er1,riwaterm8(i),er2
    106 format(2x,f6.0,1x,f6.4,2(4x,e10.3,1x,f4.1))
   end do

   do ii=1,nwater22
    i=i+1
    read(idat,fmt=108) wcmdat(i),wavedat(i),riwater22(i),er1
    108 format(2x,f6.0,1x,f6.4,1(4x,e10.3,1x,f4.1))
   end do

! Close the ascii input file
   close (idat)

! ***
   if (mset .eq. 1) then
     nlines=nicem25+nwaterm8+nwater22
    do i=1,nlines
     rival(i)=riwater22(i)
    end do
   end if

   if (mset .eq. 2) then
     nlines=nicem25+nwaterm8
    do i=1,nlines
     rival(i)=riwaterm8(i)
    end do
   end if

   if (mset .eq. 3) then
     nlines=nicem25
    do i=1,nlines
     rival(i)=riwaterm25(i)
    end do
   end if

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=0.0
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdkou: work with mset, files(mset)",/,&
    2x,i3,2x,a70,/,&
    2x,"rdkou: i,files(i)")
   do i=1,ncomp
    write(iout,810) i,files(i)
    810 format(2x,i3,2x,a70)
   end do

    write(iout,fmt=839) nlines
    839 format(/,2x,"rdkou: nlines ",i4)
    write(iout,fmt=840)
    840 format(/,2x,"rdkou: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
