  subroutine rdmyhre_hno3(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndat=6051,mtempmax=6,mcases=3
  integer :: i,j1,j2,k1,k2,mn,nc
  integer :: nhno3temp(mcases)
  real :: a1,a2
  real :: wghthno3
! Note that the ndat,mtemp is opposite to the ncdump dump
  real :: numlinesr(mcases),numlinesi(mcases)
  real :: temps(mcases,mtempmax)
  real :: ntemps(mcases)
  real :: whno3(mcases)
  real :: wcmr(ndat,mcases),wavelengthr(ndat,mcases)
  real :: wcmi(ndat,mcases),wavelengthi(ndat,mcases)
  real :: rn(ndat,mcases,mtempmax)
  real :: ri(ndat,mcases,mtempmax)
  character(len=60) :: fil
  character (len=16) :: llset
  character (len=60) :: files(mcases)

  data ntemps/6,5,5/
  data whno3/30,54,64/

! files(1)
  temps(1,1)=293.0
  temps(1,2)=273.0
  temps(1,3)=253.0
  temps(1,4)=243.0
  temps(1,5)=233.0
  temps(1,6)=223.0
! files(2)
  temps(2,1)=293.0
  temps(2,2)=273.0
  temps(2,3)=253.0
  temps(2,4)=243.0
  temps(2,5)=243.0
! files(3)
  temps(3,1)=293.0
  temps(3,2)=273.0
  temps(3,3)=253.0
  temps(3,4)=243.0
  temps(3,5)=233.0

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! Data: Real and imaginary indices of binary HNO3/H2O
! at 223, 233, 243, 253, 273 and 293 K from 450 to 6500 cm-1  30% HNO3, 70% H2O

! Reference: Myhre, C. E. Lund, H. Grothe, A. A. Gola, and C. J.
! Nielsen, Optical Constants of HNO3/H2O and H2SO4/HNO3/H2O at Low
! Temperatures in the Infrared Region, J. Phys. Chem., volume 109,
! pgs. 7166-7171, 2005.

! Email contact person: C. J. Nielsen (c.j.nielsen@kjemi.uio.no.)

! Format: 6051 real indices (2x,f7.2,2x,f10.4,6(2x,f7.5))
!         6051 imaginary indices (2x,f7.2,2x,f10.4,4(1x,e11.4))

! cm-1        microns  real293  real273  real253  real243  real233  real223
! 6500.00      1.5385  1.37170  1.38310  1.40010  1.39730  1.39540  1.40150
! 6499.00      1.5387  1.37170  1.38320  1.39910  1.39760  1.39370  1.40140

!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='myhre_hno3/myhrebin30hno3.dat                               '
  files(2)='myhre_hno3/myhrebin54hno3.dat                               '
  files(3)='myhre_hno3/myhrebin64hno3.dat                               '

  do nf=1,mcases

! The input ascii file
  fil=files(nf)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
    nlines=ndat
    nc=ntemps(nf)
   do i=1,nlines
    read(idat,*) wcmr(i,nf),wavelengthr(i,nf),(rn(i,nf,j),j=1,nc)
   end do

  do i=1,2
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmi(i,nf),wavelengthi(i,nf),(ri(i,nf,j),j=1,nc)
   end do

  end do

  close (idat)

! ***
  write(0,fmt=160)
  160 format(2x,"Specify wghthno3 value (e.g. 30, 54, 64) ")
  read(5,*) wghthno3

! The compound string
!       '1234567890123456'
  llset=' Myhre HNO3     '

  write(0,fmt=170) wghthno3
  170 format(2x," wghthno3 ",f10.4)

! *****
! Find the indices for the interpolation

! The whno3 values
  if (nopr .eq. 1) then
   write(iout,fmt=320) 
   320 format(/,2x,"rdmyhre_hno3: i,whno3(i)")
   do i=1,mcases
    write(iout,fmt=330) i,whno3(i)
    330 format(2x,i4,2x,f10.4)
   end do
  end if

! Get case (whno3 value)
    j1=-99
   if (wghthno3 .le. whno3(1)) then
    j1=1
    go to 400
   end if
   if (wghthno3 .ge. whno3(3)) then
    j1=3
    go to 400
   end if
  do i=1,mcases-1
    i2=i+1
   if ((wghthno3 .ge. whno3(i)) .and. (wghthno3 .lt. whno3(i2))) then
    j1=i
    go to 400
   end if
  end do
  400 mn=0

  if (j1 .lt. 0) then
   write(iout,fmt=350) j1
   350 format(/,2x,"rdmyhre_hno3: j1 lt 0 ",i4," will stop")
   stop
  end if

  numtemp=ntemps(j1)

  if (nopr .eq. 1) then
   write(iout,fmt=410) wghthno3,whno3(j1),j1,numtemp
   410 format(/,2x,"rdmyhre_hno3: wghthno3,whno3(j1),j1,numtemp ",/,&
   2x,2(1x,f10.4),2(1x,i4))
  end if

! *****
! Specify the temperature
  if (nopr .eq. 1) then
   write(iout,fmt=420) 
   420 format(/,2x,"rdmyhre_hno3: i,temps(j1,i)")
   do i=1,numtemp
    write(iout,fmt=430) i,temps(j1,i)
    430 format(2x,i4,2x,f10.4)
   end do
  end if

  write(0,fmt=425)
  425 format(2x,"Specify temp from these values ")
  do i=1,numtemp
   write(0,fmt=435) temps(j1,i)
   435 format(2x,f10.4)
  end do

  write(0,fmt=437)
  437 format(2x,"Specify temp ")
  read(5,*) temp

   k1=-99
  if (temp .le. temps(j1,numtemp)) then
   k1=numtemp
   go to 439
  end if
  if (temp .ge. temps(j1,1)) then
   k1=1
   go to 439
  end if
  do i=1,numtemp-1
    i2=i+1
   if ((temp .le. temps(j1,i)) .and. (temp .gt. temps(j1,i2))) then 
    k1=i
    go to 439
   end if
  end do
  439 mn=0

  if (nopr .eq. 1) then
   write(iout,fmt=440) temp,k1,temps(j1,k1)
   440 format(/,2x,"rdmyhre_hno3: temp,k1,temps(j1,k1)  ",/,&
   2x,1(1x,f10.4),1(1x,i4),1(1x,f10.4))
  end if

  if (k1 .lt. 0) then
   write(iout,fmt=442) j1
   442 format(/,2x,"rdmyhre_hno3: k1 lt 0 ",i4," will stop")
   stop
  end if

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmr(i,j1)
   wavelength(i)=wavelengthr(i,j1)
   a1=rn(i,j1,k1)
   a2=ri(i,j1,k1)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   rndat(i)=a1
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) temp,wghthno3
    800 format(/,2x,"rdmyhre_hno3: temp,wghthno3 ",/,2x,2(1x,f10.4),/,&
    2x,"rdmyhre_hno3: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
