  pro calcext,nopr,iout,$
  iwave,nwave,wave,rn,ri,$
  ndist,radr,sized,$
  bext,babs,bsca,asym,back,omega,$
  outdir,igraphe,iwrext,lset,$
  ngraph,nlast

; *************************
  ngraph=ngraph+1

; *************************
   pi=3.14159265
   const=sqrt(2.00*pi)
   constx=2.00*pi*1.0e-4
   refmed=1.00
   nang=20
   s1=complexarr(2*nang)
   s2=complexarr(2*nang)

; ****
; For the size distribution
   volume=0.0
   area=0.0
   rave=0.0
   totden=0.0

; ****
; The radii increments
    dr=fltarr(ndist)
   for i=0,ndist-2 do begin
    i1=i
    i2=i+1
    dr(i)=radr(i2)-radr(i1)
   endfor
    i3=ndist-1
    i2=ndist-2
   dr(i3)=dr(i2)

; ****
; Output arrays
   bext=fltarr(nwave)
   babs=fltarr(nwave)
   bsca=fltarr(nwave)
   asym=fltarr(nwave)
   back=fltarr(nwave)
   omega=fltarr(nwave)

; ****
; Loop over spectra grid
  for i=0,nwave-1 do begin

;   print,i

; Initialize for each spectra grid point
   bext(i)=0.0
   babs(i)=0.0
   bsca(i)=0.0
   asym(i)=0.0
   back(i)=0.0
   omega(i)=0.0

; For wavenumbers
   if (iwave eq 1) then begin
    wavcm=wave(i)
   endif
; For wavelength in microns, calculate wavcm
   if (iwave eq 2) then begin
    wavcm=1.0e4/wave(i)
   endif

; The complex index of refraction
   refre=rn(i)
   refim=ri(i)
   refrel=complex(refre,refim)/refmed

; Loop over the size distribution
   for j=0,ndist-1 do begin

; The Mie x parameter (2 pi Radius / Wavelength)
   x=constx*radr(j)*wavcm

; Use the Bohren and Huffman BHMIE routine
   bhmie2,x,refrel,nang,s1,s2,qext,qsca,qback,gfac
 
; The Q absorption efficieny factor 
   qabs=qext-qsca

; Calculate the extinction, scattering, absorption coefficient
; 1.0e-3 converts cm-1 to km-1
; sized(j) is number of particles per cm3 per micron
    rd2=radr(j)*radr(j)
    weight=pi*rd2*sized(j)*dr(j)*1.0e-3

; Add to the output arrays
   bext(i)=bext(i)+(weight*qext)
   babs(i)=babs(i)+(weight*qabs)
   bsca(i)=bsca(i)+(weight*qsca)
   back(i)=back(i)+(weight*qback)
   asym(i)=asym(i)+(weight*qsca*gfac)

  endfor
; Loop over the size distribution is done

; ***
; The asymmetry factor
   asym(i)=asym(i)/bsca(i)

; The single scattering albedo
   omega(i)=bsca(i)/bext(i)

  endfor
; Loop over spectra grid points is done

; *************************
  if (nopr eq 1) then begin
   printf,iout,'  '
   printf,iout,'  calcext: bext,babs,bsca, are in 1/km units'
   printf,iout,'  calcext: asym,omega are unitless'
   printf,iout,'  calcext: i,wave(i),bext(i),babs(i),bsca(i),asym(i),omega(i)'
   for i=0,nwave-1 do begin
    printf,iout,format='(1(1x,i3),1(1x,f10.4),5(1x,e10.3))',$
     i,wave(i),bext(i),babs(i),bsca(i),asym(i),omega(i)
   endfor
  endif

; *************************
; Write the spectra out to ascii and netCDF files
   if (iwrext eq 1) then begin
    wrext,nopr,iout,outdir,iwave,$
    nwave,wave,bext,babs,bsca,asym,omega
   endif

; *************************
; Graph the results

; The output ps graphics file
    fileps=strcompress(outdir+'gext.ps')

; *****
; Open the output ps file
   if ((igraphe eq 1) and (ngraph eq 1)) then begin
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0
   endif

; *****
; Graph the results
   if (igraphe eq 1) then begin
     ngraphs=5
     titles=strarr(ngraphs)
     titles=['Extinction (km-1)','Absorption (km-1)','Scattering (km-1)',$
      'Asymmetry Parameter ','Single Scattering Albedo'] 

      arrays=fltarr(nwave,ngraphs)
     for i=0,nwave-1 do begin
      arrays(i,0)=bext(i)
      arrays(i,1)=babs(i)
      arrays(i,2)=bsca(i)
      arrays(i,3)=asym(i)
      arrays(i,4)=omega(i)
     endfor

     xvec=fltarr(nwave)
     yvec=fltarr(nwave)
     isym=intarr(nwave)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,nwave-1 do begin
       xvec(i)=wave(i)
       yvec(i)=arrays(i,ii)
       isym(i)=4
      endfor

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif
    labely=titles(ii)
    title=lset

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=0
    iylog=0
    ioplot=1

    graphxy,iout,xvec,yvec,isym,nwave,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs
   endif

; ************************
; Close the output ps graphics file
   if (ngraph eq nlast) then begin
    print,' calcext: wrote to ',fileps
    device,/close
   endif

; *************************
  return
  end
