   pro rddingle_soa,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; One file
   fil=strarr(1)
   fil='dingle_soa.nc'

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; netcdf dingle_soa {
; dimensions:
;     nlines = 25 ;
;     ntext = 9 ;
;     nlab = 31 ;
;     n70 = 70 ;
;     n60 = 60 ;
;     xsize1 = 9 ;
;     string_length1 = 72 ;
;     xsize2 = 31 ;
;     string_length2 = 62 ;
; variables:
;      short nlines ;
;      short ntext ;
;      short n70 ;
;      short n60 ;
;      short nlab ;
;      float wcm375(nlines) ;
;      float wavelength375(nlines) ;
;      float wcm632(nlines) ;
;      float wavelength632(nlines) ;
;      float rn375(nlines) ;
;      float ri375(nlines) ;
;      float rn632(nlines) ;
;      char text(xsize1, string_length1) ;
;      char labstr(xsize2, string_length2) ;

; ***
; The input netCDF file
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnlines=ncdf_varid(nc_id,'nlines')
  ncdf_varget,nc_id,idnlines,nlines

  idnlab=ncdf_varid(nc_id,'nlab')
  ncdf_varget,nc_id,idnlab,nlab

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

  idn60=ncdf_varid(nc_id,'n60')
  ncdf_varget,nc_id,idn60,n60

; print,n60,n70,ntext,nlines,nlab
; stop

; ****
;  text=strarr(n70,ntext)
   text=strarr(ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

;  labstr=strarr(n60,nlab)
   labstr=strarr(nlab)
  idlabstr=ncdf_varid(nc_id,'labstr')
  ncdf_varget,nc_id,idlabstr,labstr
  labstr=string(labstr)

; *****
; Read in the data
  idwcm375=ncdf_varid(nc_id,'wcm375')
  idwavelength375=ncdf_varid(nc_id,'wavelength375')
  idrn375=ncdf_varid(nc_id,'rn375')
  idri375=ncdf_varid(nc_id,'ri375')

  idwcm632=ncdf_varid(nc_id,'wcm632')
  idwavelength632=ncdf_varid(nc_id,'wavelength632')
  idrn632=ncdf_varid(nc_id,'rn632')

; ***
; Get data
  ncdf_varget,nc_id,idwcm375,wcm375
  ncdf_varget,nc_id,idwavelength375,wavelength375
  ncdf_varget,nc_id,idrn375,rndat375
  ncdf_varget,nc_id,idri375,ridat375

  ncdf_varget,nc_id,idwcm632,wcm632
  ncdf_varget,nc_id,idwavelength632,wavelength632
  ncdf_varget,nc_id,idrn632,rndat632

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Select the laboratory condition to work with
   print,'  '
   print,'  rddingle_soa: nlab ',nlab
   print,'  rddingle_soa: i,labstr(i)'
  for i=0,nlab-1 do begin
   print,'  ',i,'  ',labstr(i)
  endfor

  print,'  specify the ilab condition to work with, ilab=0-24'
  read,ilab
  ilab=fix(ilab)

  print,'  ilab = ',ilab
  print,'  labstr(ilab) ',labstr(ilab)

  printf,iout,'  rddingle_soa: ilab ',ilab
  printf,iout,'  rddingle_soa: labstr(ilab) ',labstr(ilab)

; *****
; Output
  wcm=fltarr(1)
  wavelength=fltarr(1)
  rndat=fltarr(1)
  ridat=fltarr(1)

  nlines=1
  wcm(0)=wcm375(ilab)
  wavelength(0)=wavelength375(ilab)
  rndat(0)=rndat375(ilab)
  ridat(0)=ridat375(ilab)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rddingle_soa: filnm ',filnm
    printf,iout,'  rddingle_soa: nlines ',nlines
    printf,iout,'  '
    printf,iout,'  rddingle_soa: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,'  ',text(i)
   endfor

   printf,iout,'  '
   printf,iout,'   rddingle_soa: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

    iwrorig=0
   if (iwrorig eq 1) then begin

    printf,iout,'  '
    printf,iout,'   rddingle_soa: i,wcm375,wavelength375,rndat375 and ridat375'
    for i=0,nlines-1 do begin
     printf,iout,'  ',i,wcm375(i),wavelength375(i),rndat375(i),ridat375(i)
    endfor

    printf,iout,'  '
    printf,iout,'   rddingle_soa: i,wcm625,wavelength625,rndat625'
    for i=0,nlines-1 do begin
     printf,iout,'  ',i,wcm625(i),wavelength625(i),rndat625(i)
    endfor

   endif

  endif

; ******
  return
  end
