   pro rdtisdale,nopr,iout,filnm,$
   ntext,text,$
   nweights,h2so4wt,$
   nlines,wcm,wavelength,rn8,ri8

; ******
; Read in the data from the netCDF file

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnweights=ncdf_varid(nc_id,'nweights')
  idh2so4wt=ncdf_varid(nc_id,'h2so4wt')
  idnlines=ncdf_varid(nc_id,'nlines')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn8=ncdf_varid(nc_id,'rn8')
  idri8=ncdf_varid(nc_id,'ri8')
  idtext=ncdf_varid(nc_id,'text')
  idn80=ncdf_varid(nc_id,'n80')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn80,n80
  ncdf_varget,nc_id,idnweights,nweights
  ncdf_varget,nc_id,idh2so4wt,h2so4wt
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn8,rn8
  ncdf_varget,nc_id,idri8,ri8

; text=strarr(n80,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdtisdale: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   vec8=fltarr(nweights)

   printf,iout,'  '
   printf,iout,'  rdtisdale: h2so4wt ',h2so4wt
   printf,iout,'  rdtisdale: i,wcm,wavelength,real indices'
   for i=0,nlines-1 do begin
    for j=0,nweights-1 do begin
     vec8(j)=rn8(i,j)
    endfor
    printf,iout,'  ',i,wcm(i),wavelength(i),vec8
   endfor

   printf,iout,'  '
   printf,iout,'  rdtisdale: h2so4wt ',h2so4wt
   printf,iout,'  rdtisdale: i,wcm,wavelength,imaginary indices'
   for i=0,nlines-1 do begin
    for j=0,nweights-1 do begin
     vec8(j)=ri8(i,j)
    endfor
    printf,iout,'  ',i,wcm(i),wavelength(i),vec8
   endfor

  endif

; ******
  return
  end


