   pro rdwagner_supercooled,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='wagner_supercooled.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idtemps=ncdf_varid(nc_id,'temps')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; 238.000      252.000      258.000      269.000
   print,'  '
   print,'  wagner supercooled water: specify temp (238,252,258,269) K'
   read,temp

    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    j=-99
   if (temp eq 238) then begin
    j=0
    tempstr=' 238 K'
   endif
   if (temp eq 252) then begin
    j=1
    tempstr=' 252 K'
   endif
   if (temp eq 258) then begin
    j=2
    tempstr=' 258 K'
   endif
   if (temp eq 269) then begin
    j=3
    tempstr=' 269 K'
   endif

   if ((j lt 0) or (j gt 3)) then begin
    print,'  '
    print,'  rdwagner_supercooled: specified temp yields wrong j, will stop'
    stop
   endif

   for i=0,nlines-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdwagner_supercooled: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdwagner_supercooled: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


