   pro user,nopr,iout,$
   iwave,w1,w2,dw,$
   outdir,lset,$
   nwave,wave,rn,ri

; *************************
; To test the routine put itest=1
   itest=0

; *************************
; Write out input to user.pro
   iwrind=1
  if (iwrind eq 1) then begin
    printf,iout,'  '
    printf,iout,'  user: iwave,w1,w2,dw ' 
    printf,iout,'  ',iwave,w1,w2,dw
    printf,iout,'  user: i,wave(i),rn(i),ri(i)'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wave(i),rn(i),ri(i)
   endfor
  endif

; Determine how many blocks of 5 to write out
   num5=5
   n5=nwave/num5
   if (n5 lt 1) then begin
    n5=1
   endif
   mwave=n5*num5
  printf,iout,'  '
  printf,iout,'  user: nwave,n5,mwave ',nwave,n5,mwave

  if (mwave ne nwave) then begin
   printf,iout,'  user: oops, nwave ne mwave, will stop '
   printf,iout,'  user: respecify wavenumber range in work.dat '
   stop
  endif

; *************************
; The rest of this routine is supplied by the user

; icalc=1 for ice particles
; icalc=2 for liquid droplets
   icalc=1

; Density rho of material in gm/cm3
  if (icalc eq 1) then begin
   fwr='/ur/massie/genln3/G3_HT2012/exoplanet_ice.dat4'
   rho=0.916
  endif
  if (icalc eq 2) then begin
   fwr='/ur/massie/genln3/G3_HT2012/exoplanet_liq.dat4'
   rho=1.00
  endif

  printf,iout,'  '
  printf,iout,'  user: icalc and output file ',icalc
  printf,iout,'  ',fwr

; *************************
; Input
; See /ur/massie/genln3/G3_HT2012/zuseidl/task3.pro

    fsave='/ur/massie/genln3/G3_HT2012/zuseidl/exoplanet.sav'

;  save,nlev,heightkm,dzkm,press,temp,dencm3,co2ppmv,h2oppmv,$
;  liqcld,icecld,reffliq,reffice,relhum$
;  file=fsave,/verbose

    restore,fsave

; Note that altitude is from highest to lowest
   i1=0
   i2=nlev-1
   iskip=-1

; Write out inputs
    noprg=1
   if (noprg eq 1) then begin
     printf,iout,'  '
     printf,iout,'  user: i,heightkm,press,temp,liqcld,icecld,reffliq,reffice,relhum'
    for i=i2,i1,iskip do begin
     printf,iout,format='(2x,i3,8(1x,f10.4))',$
      i,heightkm(i),press(i),temp(i),$
      liqcld(i),icecld(i),reffliq(i),reffice(i),relhum(i)
    endfor
   endif

; *************************
; Output arrays
   bextwr=fltarr(nwave,nlev)
   babswr=fltarr(nwave,nlev)
   bscawr=fltarr(nwave,nlev)
   asymwr=fltarr(nwave,nlev)
   backwr=fltarr(nwave,nlev)
   omegawr=fltarr(nwave,nlev)

   ratio=fltarr(nlev)
   gm2=fltarr(nlev)

; *************************
    iwrsp=1
   if (iwrsp eq 1) then begin
    printf,iout,'  '
    printf,iout,'  user: ii,heightkm,rad1,gm2,sum,ratio '
   endif

; Loop over the altitude levels
; Loop from lowest to highest
    ilev=-1
    i4=i2
    i3=i1
    if (itest eq 1) then begin
     i3=i4-15
    endif
   for ii=i4,i3,iskip do begin

   ilev=ilev+1
   print,'  ii,ilev ',ii,ilev

; ****
; Specify the size distribution parameters

   perc1=0.90
   perc2=1.10

; For ice
   if (icalc eq 1) then begin
    r1=reffice(ii)*perc1
    r2=reffice(ii)*perc2
    den1=1.0
    rad1=reffice(ii)
    sig1=1.5
    den2=0.0
    rad2=-999.0
    sig2=-999.0
    gm2(ii)=icecld(ii)
   endif

; For liquid droplets
   if (icalc eq 2) then begin
    r1=reffliq(ii)*perc1
    r2=reffliq(ii)*perc2
    den1=1.0
    rad1=reffliq(ii)
    sig1=1.5
    den2=0.0
    rad2=-999.0
    sig2=-999.0
    gm2(ii)=liqcld(ii)
   endif

; ****
; Calculate the size distribution
    igraphd=0
    iwrsize=0
    lsetsz='useer dist'
     noprsize=0
   calcsized,noprsize,iout,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   outdir,igraphd,iwrsize,$
   lsetsz

; *****
; radr is in microns

; drad is incrment bin in microns
    drad=fltarr(ndist)
   for i=0,ndist-2 do begin
    drad(i)=radr(i+1)-radr(i)
   endfor

; 1 micron=1.0e-6 meter=1.0e-4 cm  So multiply by 1.0e-12 to get cm3 
; sized = number per cm3 per micron radius increment
;   rho(gm/cm3)*sized(1/cm3*micron)*radr^3*drad(micron) = density in gm/cm3
; Multiply by 1.0e6 to gm/m3
    sum=0.0
    convr=1.0e-12*1.0e6
   for i=0,ndist-1 do begin
    r3=convr*(radr(i)^3.0)
    a1=rho*sized(i)*r3*drad(i)
    sum=sum+a1
   endfor

; Multiply by dzkm to get gm/m2
; dzkm is in km, so multiply by 1.0e3 to get m
   sum=sum*dzkm(ii)*1.0e3

; Find ratio of desired g/m2 of particles to sum from your den1=1.0 calculation
    ratio(ii)=0.0
   if (gm2(ii) gt 1.0e-4) then begin
    ratio(ii)=gm2(ii)/sum
   endif

; Write out progress
   if (iwrsp eq 1) then begin
    printf,iout,' ' ,ii,heightkm(ii),rad1,gm2(ii),sum,ratio(ii)
;   stop
   endif

; For no input gm2, will not calculate
   if (gm2(ii) lt 1.0e-4) then begin
    goto,jump1
   endif

; ****
; Proced if you have data to work

; Multiply the size distribution by ratio so that you have appropriate g/m2 for the calculation
   for i=0,ndist-1 do begin
    sized(i)=sized(i)*ratio(ii)
   endfor

; ****
; Calculate the spectra (extinction, absorption, scattering, single scattering
; albedo, and asymmetry parameter)
    igraphe=0
    iwrext=0
    noprext=1
   ngraph=0
   nlast=-999
  calcext,noprext,iout,$
  iwave,nwave,wave,rn,ri,$
  ndist,radr,sized,$
  bext,babs,bsca,asym,back,omega,$
  outdir,igraphe,iwrext,lset,$
  ngraph,nlast

; ****
; Put values into the output arrays
   for i=0,nwave-1 do begin
    bextwr(i,ilev)=bext(i)
    babswr(i,ilev)=babs(i)
    bscawr(i,ilev)=bsca(i)
    asymwr(i,ilev)=asym(i)
    backwr(i,ilev)=back(i)
    omegawr(i,ilev)=omega(i)
   endfor

   jump1:mn=0

   endfor
; Loop over altitude levels

; *************************
; Write out ratio values
    printf,iout,'  user: nlev ',nlev
    printf,iout,'  user: i,heightkm(i),gm2(i),ratio(i)'
   for i=0,nlev-1 do begin
    printf,iout,'  ',i,heightkm(i),gm2(i),ratio(i)
   endfor

; *************************
; Write out to the output ascii file

; Open output ascii file
    idat=45
   openw,idat,fwr

   header=strarr(1)

; **
   header='Number of wavenumbers'
   printf,idat,header
   printf,idat,'  ',nwave
   printf,idat,'  i,wave(i)'
   for i=0,nwave-1 do begin
    printf,idat,format='(2x,i4,2x,f10.4)',$
     i,wave(i)
   endfor

; **
   header='Number of altitude levels'
   printf,idat,header
   printf,idat,'  ',nlev
   printf,idat,'  i,heightkm(i)'
    ii=-1
    j1=0
    j2=nlev-1
    jskip=-1
   for i=j2,j1,jskip do begin
    ii=ii+1
    printf,idat,format='(2x,i4,2x,f10.4)',$
     ii,heightkm(i)
   endfor

; **
   header='For each altitude level, the extinction in 1/km units'
   printf,idat,header
    dat5=fltarr(num5)
   for i=0,nlev-1 do begin
; Write out altitude level and n5 value
    printf,idat,format='(2x,i4,2x,i4)',$
     i,n5
; Will write out every 5 values
    for n=0,n5-1 do begin
      m=-1
      j1=0+(n*5)
      j2=4+(n*5)
     for j=j1,j2 do begin
      m=m+1
      dat5(m)=bextwr(j,i)
     endfor
     printf,idat,format='(2x,5(1x,f10.4))',$
      dat5
    endfor
   endfor

; **
   close,idat
   print,fwr

; *************************
  return
  end
