   pro wrindices,nopr,iout,outdir,$
   nlines,wave,rn,ri,iwave,$
   lset

; *************************
  filnm=strarr(1)
  filnm=strcompress(outdir+'indices.ascii')

   idat=30
  openw,idat,filnm

; Will write out both wavenumbers and wavelength
  wavecm=fltarr(nlines)
  wavelength=fltarr(nlines)

; Write out to the output ascii file
    printf,idat,'  wrindices: lset ',lset
    printf,idat,'  wrindices: nlines '
    printf,idat,'  ',nlines
    printf,idat,'  wrindices: i,wavecm,wavelength,rn,ri'
   for i=0,nlines-1 do begin
    if (iwave eq 1) then begin
     a1=wave(i)
     a2=1.0e4/wave(i)
    endif
    if (iwave eq 2) then begin
     a1=1.0e4/wave(i)
     a2=wave(i)
    endif
     wavecm(i)=a1
     wavelength(i)=a2
    printf,idat,format='(1(1x,i4,","),2(1x,f10.4,","),2(1x,e10.3,","))',$
     i,a1,a2,rn(i),ri(i)
   endfor

   print,'  wrindices: wrote to ',filnm
   close,idat

; *************************
; Write out to the output netCDF file
  wrfile=strarr(1)
  wrfile=strcompress(outdir+'indices_interp.nc')

; **
   ntext=2
   n40=40
  text=strarr(ntext)

  text0=strarr(1)
;       '1234567890123456789012345678901234567890'
  text0='                                        '
  strput,text0,lset,0
  text(0)=text0

;         '1234567890123456789012345678901234567890'
  text(1)=' The real and imaginary indices         '

; **
; Open the netCDF file
; The file is in define mode
     id=NCDF_CREATE(wrfile,/CLOBBER)

; **
; Define variable ids
     idnlines=NCDF_DIMDEF(id,'nlines',nlines)
     idntext=NCDF_DIMDEF(id,'ntext',ntext)

; For character strings
     idn40=NCDF_DIMDEF(id,'n40',n40)

; **
; Define variables
     id1=NCDF_VARDEF(id,'nlines',/SHORT)
     id2=NCDF_VARDEF(id,'ntext',/SHORT)
     id3=NCDF_VARDEF(id,'n40',/SHORT)

      dimx=[idnlines]
     id9=NCDF_VARDEF(id,'wavecm',dimx)
     id10=NCDF_VARDEF(id,'wavelength',dimx)
     id11=NCDF_VARDEF(id,'rn',dimx)
     id12=NCDF_VARDEF(id,'ri',dimx)

; **
; The text associated with the file
     id20=NCDF_VARDEF(id,'text',[idn40,idntext],/CHAR)

; **
; Put the file in data mode (so you can write to it)
     NCDF_CONTROL,id,/ENDEF

; **
; Specify the values
     NCDF_VARPUT,id,id1,nlines
     NCDF_VARPUT,id,id2,ntext
     NCDF_VARPUT,id,id3,n40

      countx=[nlines]
     NCDF_VARPUT,id,id9,wavecm,COUNT=countx
     NCDF_VARPUT,id,id10,wavelength,COUNT=countx
     NCDF_VARPUT,id,id11,rn,COUNT=countx
     NCDF_VARPUT,id,id12,ri,COUNT=countx

; Write out the character strings
     counts=[n40,ntext]
     NCDF_VARPUT,id,id20,text,COUNT=counts

; **
; Close the data set
     NCDF_CLOSE,id

; **
    print,'  wrindices: wrote to ',wrfile

    printf,iout,'  '
    printf,iout,'  wrindices: wrote to netCDF file '
    printf,iout,'  ',wrfile

; *************************
  return
  end
