   pro rdalexander_brown_carbon,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
   lset=strcompress(lstrn)

; ***
; The input netCDF file
  fil=strarr(1)
  fil='alexander_brown_carbon.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idnev=ncdf_varid(nc_id,'nev')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idev=ncdf_varid(nc_id,'ev')
  ideps1=ncdf_varid(nc_id,'eps1')
  ideps2=ncdf_varid(nc_id,'eps2')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; *****
; Get the data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idnev,nev
  ncdf_varget,nc_id,idev,ev
  ncdf_varget,nc_id,ideps1,eps1
  ncdf_varget,nc_id,ideps2,eps2
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
    nlines=nwave
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
   for i=0,nlines-1 do begin
    rndat(i)=rn(i)
    ridat(i)=ri(i)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdalexander_flame_soot: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdalexander_flame_soot: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdalexander_flame_soot: i,ev,eps1,eps2,'
   for i=0,nev-1 do begin
    printf,iout,'  ',i,ev(i),eps1(i),eps2(i)
   endfor

  endif

; ******
  return
  end


