  pro tisdale,nopr,iout,indir,outdir,lstrn,iset,lset,$
  nlines,wcm,wavelength,rndat,ridat,iwave

; *****
; Will work with the Tisdale H2SO4 cold temperature indices

; *****
; The input netCDF file
   fil=strarr(1)
   fil='tisdale_h2so4.nc'
   filnm=strcompress(indir+fil)

; **
; Read in from the netCDF file
   rdtisdale,nopr,iout,filnm,$
   ntext,text,$
   nweights,h2so4wt,$
   nlines,wcm,wavelength,rn8,ri8

; **
; Specify the weight percent h2so4 to use
   print,' '
   print,' Tisdale H2SO4 indices'
   print,' Specify the weight percent h2so4 to use (between 46.0 and 80.0)'
   read,h2so4

   addstr=string(h2so4)
   lset=strcompress(lstrn+' '+addstr)

    ifound=-99
   for i=0,nweights-1 do begin
    if (h2so4 ge h2so4wt(i)) then begin
     ifound=i
     j1=i
     j2=i+1
    endif
   endfor
   if ((ifound ge 0) and (j2 ge nweights)) then begin
    j1=ifound-1
    j2=ifound
   endif

   if (nopr eq 1) then begin
    printf,iout,'  '
    printf,iout,'  tisdale: specified h2so4 ',h2so4
    printf,iout,'  tisdale: j1,j2,h2so4wt(j1),h2so4wt(j2)'
    printf,iout,'  ',j1,j2,h2so4wt(j1),h2so4wt(j2)
   endif

; **
; Obtain the indices for this h2so4 value
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    dwght=h2so4-h2so4wt(j1)
    div=h2so4wt(j2)-h2so4wt(j1)
    if (nopr eq 1) then begin
     printf,iout,'  i,wcm(i),wavelength(i),rndat(i),ridat(i)'
    endif
   for i=0,nlines-1 do begin

    deriv=(rn8(i,j2)-rn8(i,j1))/div
     a1=rn8(i,j1)+(dwght*deriv)
    if (a1 lt 0.0) then begin
     a1=0.0
    endif
    rndat(i)=a1

    deriv=(ri8(i,j2)-ri8(i,j1))/div
     a2=ri8(i,j1)+(dwght*deriv)
    if (a2 lt 0.0) then begin
     a2=0.0
    endif
    ridat(i)=a2

    if (nopr eq 1) then begin
     printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
    endif
   endfor

; Tisdale h2so4 done

; *************************
  return
  end
