  subroutine rdfabian_fe2sio4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=5000,ncomp=3
  integer :: noprf,mset
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! **
! The different compositions
!          '1234567890123456'
  files(1)='Fabian Fe2SiO4 x'
  files(2)='Fabian Fe2SiO4 y'
  files(3)='Fabian Fe2SiO4 z'

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset 1,2,3 ")

  read(5,*) mset
  mset=int(mset)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
  if (mset .eq. 1) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/fabian_fe2sio4_x.dat                             '
!       '1234567890123456'
   llset='fe2sio4 x                   '
  end if
  if (mset .eq. 2) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/fabian_fe2sio4_y.dat                             '
!       '1234567890123456'
   llset='fe2sio4 y                   '
  end if
  if (mset .eq. 3) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/fabian_fe2sio4_z.dat                             '
!       '1234567890123456'
   llset='fe2sio4 z                   '
  end if

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Fabian, D., T. Henning, C. Jager, H. Mutschke, J. Dorschner
! and O. Wehrhan, Steps toward interstellar silicate mineralogy
! VI. Dependence of crystalline olivine IR spectra on iron content and
! particle shape
! Astronomy and Astrophysics, v 378, p228-238, 2001
!
! Real and Imaginary Refractive Indices of Fe2Sio4 (Fayalite)
!
! Contact: H. Mutschke (harald.mutschke@uni-jena.de)
!
! Format: 5000 lines 2x,2(1x,f8.2),2(1x,f10.4)
!
!      cm-1    microns     real    imaginary
!    5000.00     2.00     1.8618     0.0000
!    4999.00     2.00     1.8618     0.0000

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
    wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdfabian_fe2sio4: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdfabian_fe2sio4: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e12.5),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
