  subroutine rdhenning_sio2_lowtemp(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=253,ncomp=4
  integer :: noprf,mset
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset
  character (len=16) :: llsets(ncomp)
  character (len=60) :: filei(ncomp)

! **
! The different compositions
!          '1234567890123456'
  files(1)='SiO2 10K        '
  files(2)='SiO2 100K       '
  files(3)='SiO2 200K       '
  files(4)='SiO2 300K       '

! You put all data in one ascii file
!          '123456789012345678901234567890123456789012345678901234567890'
  filei(1)='exoplanets/henning_mutschke_sio2_10K.dat                    '
  filei(2)='exoplanets/henning_mutschke_sio2_100K.dat                   '
  filei(3)='exoplanets/henning_mutschke_sio2_200K.dat                   '
  filei(4)='exoplanets/henning_mutschke_sio2_300K.dat                   '

!            '1234567890123456'
   llsets(1)='sio2 10K        '
   llsets(2)='sio2 100K       '
   llsets(3)='sio2 200K       '
   llsets(4)='sio2 300K       '

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset, 1,2,3,or 4 ")

  read(5,*) mset
  mset=int(mset)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
   fil=filei(mset)
   llset=llsets(mset)

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Henning, T. and H. Mutschke, Low Temperture infrared
! properties of cosmic dust analogues
! Astronomy and Astrophysics, v327, p743-754, 1997

!! Real and Imaginary Refractive Indices of amorphous SiO2 at 10K
!
! Contact: Thomas Henning (henning@mpia.de)
!
! Format: 253 lines 2x,2(1x,f8.2),2(1x,f10.4)

!      cm-1    microns     real    imaginary
!    1497.80     6.68     1.1555     0.0169
!    1491.94     6.70     1.1532     0.0155

! *****
! Read in the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,11
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdhenning_sio2_lowtemp: nlines,fil ",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdhenning_sio2_lowtemp: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
