  subroutine rdjovanovic_pluto(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=367
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='Jovanovic Pluto '

! ***
! The input ascii file
!     '123456789012345678901234567890'123456789012345678901234567890'
  fil='single_files/jovanovic_pluto_aerosol.dat                     '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
!
!  Data: Real and imaginary indices of Pluto tholins
!  from 0.27 to 2.1 microns

!  Reference:  Jovanović L, Gautier T, Broch L, Protopapa S,
!  Bertrand T, Rannou P, Fayolle M, Quirico E, Johann L, Naciri A,
!  Carrasco, N
!  Optical constants of Pluto aerosol analogues from UV to near-IR
!  Icarus, 2021;362:114398

!  Email contact person: L. Jovanovic (lora.jovanpvic@latmos.ipsl.fr)

!  Format: 367 real indices (2x,f8.2,2x,f10.4,1(2x,f5.3))
!          367 imaginary indices (2x,f8.2,2x,f10.4,1(1x,e10.3))

!    cm-1       microns   real indices
!                        Pluto
!  37037.00      0.2700  1.712
!  36364.00      0.2750  1.720

! *****
! Read in the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,17
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdjovanocic_pluto: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdjovanocic_pluto.f90d: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


