  subroutine rdniedziela_nad(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=2073
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/niedziela_nad.dat                              '
!       '1234567890123456'
  llset='niedziela NAD   '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Data: Real and imaginary indices of nitric acid dyhydrate (NAD)
! at 160 K from 700 to 4700 cm-1.

! Reference: Niedziela, R. F., R. E. Miller, and
! D. R. Worsnop, Temperature and Frequency-Dependent
! Optical Constants for Nitric Acid Dihydrate from Aerosol
! Spectroscopy, J. Phys. Chem. A., vol 102, pgs. 6477-6484, 1998.

! Email contact person:  R. E. Miller (remiller@unc.edu)

! Format: 2073 lines (2x,f7.2,2x,f10.4,2x,f5.3,1x,e10.3)

!  cm-1       microns  real   imaginary
!  700.20     14.2815  2.218  0.000E+00
!  702.13     14.2423  2.232  0.000E+00

   nlines=ndat

! ***
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),rnval(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840)
    840 format(/,2x,"rdniedziela_nad: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
