  subroutine rdquerry_diesel_soot(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  integer :: nwav1,nwav2,nwav3,nwav4
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=180,ncomp=4
  integer :: noprf,mset
  integer :: nlinesi(ncomp)
  real :: wcmdat(ndat,ncomp),wavedat(ndat,ncomp)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset
! Note: only work with one input ascii file
  character (len=60) :: filei(1)

  data nlinesi/11,9,11,11/

! **
! The different compositions
!          '1234567890123456'
  files(1)='NMSU unheated   '
  files(2)='UMKC Querry     '
  files(3)='NMSU heated     '
  files(4)='Felske          '

! Input ascii files to choose from
!          '123456789012345678901234567890123456789012345678901234567890'
  filei(1)='single_files/querry_diesel_soot.dat                         '

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset ")

  read(5,*) mset
  mset=int(mset)

! write(0,fmt=162) mset
! 162 format(2x," mset is ",2x,i4)
! stop

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
   fil=filei(1)
   llset=files(mset)

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Data: Real and imaginary indices of refraction of Diesel Soot
!
! Reference: Marvin R. Querry, Optical Constants of Minerals
! and Other Materials From The Millimeter To The Ultraviolet
! CRDEC-CR-88009, November 1987.

! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)

! Format: wavenumber(cm-1), wavelength(micron), real index, imaginary index
! 11 lines, Querry 1987 Diesel Soot - NMSU unheated
!  9 lines, Querry 1987 Diesel Soot - UMKC Querry
! 11 lines, Querry 1987 Diesel Soot - NMSU heated
! 11 lines, Querry 1987 Diesel Soot - Felske

! Querry 1987 Diesel Soot - NMSU unheated
! 11 2x,4(1x,f10.4)
! cm-1  microns   n      k
!   22222.2227     0.4500     1.5600     0.2600
!    5000.0000     2.0000     1.9100     0.3500
!    3333.3333     3.0000     2.0200     0.3400
!
! *****
! Open the input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,14
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do j=1,4 

   do i=1,4
    read(idat,fmt=100) header
   end do
    nlines=nlinesi(j)
   do i=1,nlines
    read(idat,*) wcmdat(i,j),wavedat(i,j),rnval(i,j),rival(i,j)
   end do

  end do

  close (idat)

! *****
! Put values into the output arrays
    nlines=nlinesi(mset)
  do i=1,nlines
   wcm(i)=wcmdat(i,mset)
   wavelength(i)=wavedat(i,mset)
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200)
   200 format(/)
   write(iout,fmt=210) mset,files(mset)
   210 format(2x,"rdquerry_diesel_soot: mset ",i4,2x,a16)

   write(iout,fmt=200)
   write(iout,fmt=230)
   230 format(2x,"rdquerry_diesel_soot: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
