  subroutine rdquerry_tyler_hno3_h2o(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=1802,nwt=6
  real :: wghts(nwt),whno3(nwt)
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat,nwt),rival(ndat,nwt)
  character(len=60) :: fil
  character (len=16) :: llset,files(nwt)

! The four temperatures of interest
  wghts(1)=3.1
  wghts(2)=6.1
  wghts(3)=11.8
  wghts(4)=22.3
  wghts(5)=40.3
  wghts(6)=70.0
!         '1234567890123456'
  files(1)=' 3.1% HNO3     '
  files(2)=' 6.1% HNO3     '
  files(3)=' 11.8% HNO3    '
  files(4)=' 22.3% HNO3    '
  files(5)=' 40.3% HNO3    '
  files(6)=' 70% HNO3      '

! ***
! Will specify which temperature to work with

  write(0,fmt=140)
  140 format(2x," Will select iwt=1,2,3,4,5,6 for 3.1,6.1,11.8,22.3,40.3,70")

  write(0,fmt=160)
  160 format(2x,"Specify iwt ")

  read(5,*) iwt
  iwt=int(iwt)

  if ((iwt .lt. 1) .or. (iwt .gt. 6)) then
   write(0,fmt=165)
   write(iout,fmt=165)
   165 format(2x,"iwt ",i4," will stop")
   stop
  end if

! The compound string
  llset=files(iwt)

  write(0,fmt=170) iwt,llset
  170 format(2x," iwt,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/querry_tyler_hno3_h2o.dat                      '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of liquid HNO3/H2O
!  at room temperature from 250 to 4987 cm-1 as a function
!  of the HNO3 concentration by weight. The concentrations
!  of 3.1, 6.1, 11.8, 22.3, 40.3, and 70% HNO3  correspond to
!  the molar (M) concentrations of 0.5, 1.0, 2.0, 4.0, 8.0,
!  and 15.7 cited in the Querry and Tyler paper.
!
!  Reference: Querry, M. R., and I. L. Tyler, Reflectance and
!  complex refractive indices in the infrared of aqueous
!  solutions of nitric acid, J. Chem. Phys., vol. 72,
!  pgs. 2495-2499, 1980.
!
!  Format: 1802 real indices (2x,f7.2,2x,f10.4,6(2x,f5.3))
!          1802 imaginary indices (2x,f7.2,2x,f10.4,6(1x,e10.3))
!
!   cm-1       microns            real indices
!                       3.1%   6.1%   11.8%  22.3%  40.3%  70%
!   250.31     39.9500  1.540  1.543  1.562  1.583  1.615  1.601
!   250.63     39.9000  1.540  1.544  1.562  1.584  1.616  1.602

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,18
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,nwt)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,nwt)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iwt)
   ridat(i)=rival(i,iwt)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=839) iwt,wghts(iwt)
    839 format(/,2x,"rdquerry_tyler_hno3_h2o: iwt,wghts(iwt) ",i3,2x,f10.4)
    write(iout,fmt=840)
    840 format(/,2x,"rdquerry_tyler_hno3_h2o: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
