   subroutine rdremsberg_h2so4_hno3(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ncomp=3
  integer :: i
  integer,parameter :: ndat=500,ndat1=184,ndat2=211,ndat3=44
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

  real :: sk,sn,rho
  real :: wcmdat1(ndat),wavedat1(ndat),rn1(ndat),ri1(ndat)
  real :: wcmdat2(ndat),wavedat2(ndat),rn2(ndat),ri2(ndat)
  real :: wcmdat3(ndat),wavedat3(ndat),rn3(ndat),ri3(ndat)

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! Specify by hand (have code read in values)
!          '1234567890123456'
  files(1)=' 75% H2SO4      ' 
  files(2)=' 90% H2SO4      '
  files(3)=' 68% HNO3       '

  write(0,fmt=140)
  140 format(2x," Will select  mset  value for a specific compound")
  write(0,fmt=145)
  145 format(2x," mset, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-3) e.g. mset=3 for 68% HNO3")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/remsberg_h2so4_hno3.dat                        '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of refraction of sulfuric acid
!  solutions at 75 and 90% H2SO4, by weight, plus the standard
!  deviations of the measurements.
!        Real and imaginary indices of refraction of nitric acid
!  solutions at 68% HNO3, by weight, plus the standard
!  deviations of the measurements.
!
!  Reference: E. E. Remsberg, D. Lavery, and B. Crawford, Optical
!  constants for sulfuric and nitric acids, J. Chem. and Engin. Data,
!  vol.19, pgs. 263-255, 1974.
!
!  Format: wavenumber(cm-1), wavelength(microns), imaginary index,
!  imaginary index standard deviation, real index, real index standard
!  deviation, correlation coefficient.
!  184 lines at 75% H2SO4
!  211 lines at 90% H2SO4
!   44 lines at 68% HNO3
!  2x,f6.1,2x,f6.3,5(2x,f6.4)
!
!   OPTICAL CONSTANTS FOR 75% AQUEOUS H2SO4
!   cm-1    microns    k     sk     n        sn      rho
!  1571.0   6.365   .1435   .0051  1.3957   .0072  -.6634
!  1567.8   6.378   .1423   .0051  1.3927   .0072  -.6672
!  1551.6   6.445   .1403   .0051  1.3870   .0072  -.6749
!
! ***
! Open iinput ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,22
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

  do i=1,ndat1
   read(idat,*) wcmdat1(i),wavedat1(i),ri1(i),sk,rn1(i),sn,rho
  end do
  do i=1,3
   read(idat,fmt=100) header
  end do

  do i=1,ndat2
   read(idat,*) wcmdat2(i),wavedat2(i),ri2(i),sk,rn2(i),sn,rho
  end do
  do i=1,3
   read(idat,fmt=100) header
  end do

  do i=1,ndat3
   read(idat,*) wcmdat3(i),wavedat3(i),ri3(i),sk,rn3(i),sn,rho
  end do

  close (idat)

! *****
! Put values into the output arrays

  if (mset .eq. 1) then 
    nlines=ndat1
   do i=1,nlines
    wcm(i)=wcmdat1(i)
    wavelength(i)=wavedat1(i)
    rndat(i)=rn1(i)
    ridat(i)=ri1(i)
   end do
  end if

  if (mset .eq. 2) then 
    nlines=ndat2
   do i=1,nlines
    wcm(i)=wcmdat2(i)
    wavelength(i)=wavedat2(i)
    rndat(i)=rn2(i)
    ridat(i)=ri2(i)
   end do
  end if

  if (mset .eq. 3) then 
    nlines=ndat3
   do i=1,nlines
    wcm(i)=wcmdat3(i)
    wavelength(i)=wavedat3(i)
    rndat(i)=rn3(i)
    ridat(i)=ri3(i)
   end do
  end if

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdremsberg_h2so4_hno3: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(/,2x,"rdremsberg_h2so4_hno3: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
