  subroutine rdfang_soa(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
! ndat  is the number of wavelengths
! ncomp is the number of compounts
  integer,parameter :: ndat=409,ncomp=3
  integer :: i,j1,j2,mn
  real :: diff,diffmin
! Note that the ndat,ncomp is opposite to the ncdump dump
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: llset

  character(len=20) :: setsstr(ncomp)
!            '12345678901234567890'
  setsstr(1)='SOA OHexp=0.7 day   '
  setsstr(2)='SOA OHexp=5.5 day   '
  setsstr(3)='SOA OHexp=10.6 day  '

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/fang_soa.dat                                   '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***

!  Data: Complex refractive index of secondary organic aerosols
! from 300 to 450 nm

! Reference: Fang Z, Li C, He Q, Czech H, Groger T, Zeng J, Fang H,
! Xiao S, Pardo M, Hartner E, and Meidan D, Wang X, Zimmermann R
! Laskin A, Rudich Y
! Secondary organic aerosols produced from photochemical oxidation
! of secondarily evaporated biomass burning organic gases: Chemical
! composition, toxicity, optical properties, and climate effect
! Env Int, 2021;157:106801

! Email contact person: Y. Rudich (yinon.rudich@weizmann.ac.il)

! Format: 409 real indices (2x,f8.2,2x,f10.4,3(2x,f5.3))
!         409 imaginary indices (2x,f8.2,2x,f10.4,3(1x,e10.3))

!   cm-1       microns   real indices
!                       OHexp=0.7 day   OHexp=5.5 day    OHexp=10.6 day
! 31993.86      0.3126  1.596  1.588  1.566
! 31939.70      0.3131  1.595  1.587  1.565

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,19
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,ncomp)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! ****
! Will select the labooratory condition to work with
  do i=1,ncomp
   write(0,fmt=104) i,setsstr(i)
  end do
  104 format(2x,i2,2x,a20)

  write(0,fmt=140)
  140 format(2x,"Specify iset 1 to 3")
  read(5,*) iset

  write(0,fmt=165) iset
  165 format(2x," will use iset ",i2)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iset)
   ridat(i)=rival(i,iset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840) 
    840 format(/,2x,"rdfang_soa: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
