  subroutine rdhasenkopf_organic_haze(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=1,ncomp=6
  integer :: noprf,mset,itemp,i1,i2
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=40) :: files(ncomp)
  character (len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/hasenkopf_organic_haze.dat                     '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Hasenkopf Titan'
  files(2)='Has Early Earth'
  files(3)='Khare 10% CH4  '
  files(4)='Ramirez 2% CH4 '
  files(5)='Tran 1.8% CH4  '
  files(6)='Vuitton 2% CH4 '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific case")
  write(0,fmt=145)
  145 format(2x," i, case ")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a40)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-6) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! *****
! Data: Real and imaginary indices at 532 nm of organic haze
! for Titan and early Earth, and other determinations

! Reference: C. Hasenkopf, M. Beaver, M. Trainer, H. Dewit, M. Freedman
! O. Toon, C. McKay, M. Tolbert
! Optical properties of Titan and early earth haze laboratory analogs in
! the mid-visible, Icarus, vol 207, 903-913, 2010.

! Contact: Christa Hasenkopf (Christa.Hasenkopf@colorado.edu)
!
! Note: See Table 1 of the paper which also reports values from others.
!
! case index    case
!  0            Hasenkopf   Titan
!  1            Hasenkopf   early Earth
!  2            Khare (1984)  10% CH4 in N2
!  3            Ramirez (2002)  2% CH4 in N2
!  4            Tran (2003)  1.8% CH4 in N2
!  5            Vuitton (2009) 1.8% CH4 in N2
!
! Format: 1 line 2x,2(1x,f8.2),6(1x,f10.4)
!
!      cm-1    microns     real
!                           Titan      EEarth      Khare     Ramirez    Tran
!Vuitton
!   18796.992     0.532     1.3500     1.8100     1.7100     1.5690     1.5800
!-99.0000

!      cm-1    microns     imaginary
!                           Titan      EEarth      Khare     Ramirez    Tran
!Vuitton
!   18796.992     0.532     0.0230     0.0550     0.0320     0.0025     0.0540
!0.0220

! ***
! There is just one wavelengtha at 0.532 microns
  nlines=ndat

  write(0,fmt=700) nlines
  write(iout,fmt=700) nlines
  700 format(/,2x,"nlines ",i4)

! ***
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,25
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do i=1,nlines
   read(idat,*) wcm(i),wavelength(i),(rnval(i,j),j=1,ncomp)
  end do

  do i=1,3
   read(idat,fmt=100) header
  end do
  do i=1,nlines
   read(idat,*) wcm(i),wavelength(i),(rival(i,j),j=1,ncomp)
  end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdhasenkopf_organic_haze: work with mset, files(mset)",/,&
    2x,i3,2x,a40)
    write(iout,fmt=840)
    840 format(2x,"rdhasenkopf_organic_haze: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
