   subroutine rdmyhre_ternary(nopr,iout,indir,outdir,lstrn,iset,&
   lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ncomp=3,ndat=6050,mtempmax=8
  integer :: i
  integer :: ivec1(mtempmax)
  integer :: nlinesr,nlinesi
  real :: a1
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  real :: temps(ncomp,mtempmax) 
  real :: vec1(mtempmax)
  real :: whno3(ncomp),wh2so4(ncomp),wh2o(ncomp)
  real :: numlinesr(ncomp),numlinesi(ncomp)
  integer :: ntemps(ncomp)
  character(len=60) :: fil
  character (len=16) :: llset,file2(ncomp)
  character (len=32) :: files(ncomp)
  character (len=60) :: filesdat(ncomp)

  real :: wcmr(ndat,ncomp),wavelengthr(ndat,ncomp)
  real :: wcmi(ndat,ncomp),wavelengthi(ndat,ncomp)
  real :: rn(ndat,ncomp,mtempmax)
  real :: ri(ndat,ncomp,mtempmax)
 
  data ntemps/6,8,4/
  nlines=ndat

! file1
  temps(1,1)=293.0
  temps(1,2)=273.0
  temps(1,3)=253.0
  temps(1,4)=223.0
  temps(1,5)=213.0
  temps(1,6)=203.0

! file2
  temps(2,1)=293.0
  temps(2,2)=273.0
  temps(2,3)=253.0
  temps(2,4)=223.0
  temps(2,5)=213.0
  temps(2,6)=203.0
  temps(2,7)=193.0
  temps(2,8)=183.0

! file3
  temps(3,1)=293.0
  temps(3,2)=273.0
  temps(3,3)=253.0
  temps(3,4)=223.0

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! Specify by hand (have code read in values)
!          '12345678901234567890123456789012'
  files(1)=' 21% H2SO4, 56% H2O, 23% HNO3   ' 
  files(2)=' 25% H2SO4, 58% H2O, 17% HNO3   ' 
  files(3)='  4% H2SO4, 50% H2O, 46% HNO3   ' 
!          '1234567890123456'
  file2(1)='21%s,56%w,23%nit' 
  file2(2)='25%s,58%w,17%nit' 
  file2(3)=' 4%s,50%w,46%nit ' 

  write(0,fmt=140)
  140 format(2x," Will select  mset  value for a specific compound")
  write(0,fmt=145)
  145 format(2x," mset, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a32)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-3) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=file2(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

!             '123456789012345678901234567890123456789012345678901234567890'
  filesdat(1)='myhre_ternary/myhretern21h2so423hno3.dat                    '
  filesdat(2)='myhre_ternary/myhretern25h2so417hno3.dat                    '
  filesdat(3)='myhre_ternary/myhretern4h2so446hno3.dat                     '

! ***
! Data: Real and imaginary indices of ternary droplets
! at 203, 213, 223, 253, 273 and 293 K from 450 to 6500 cm-1
! 23% HNO3, 21% H2SO4, 56% H2O

! Reference: Myhre, C. E. Lund, H. Grothe, A. A. Gola, and C. J.
! Nielsen, Optical Constants of HNO3/H2O and H2SO4/HNO3/H2O at Low
! Temperatures in the Infrared Region, J. Phys. Chem., volume 109,
! pgs. 7166-7171, 2005.

! Email contact person: C. J. Nielsen (c.j.nielsen@kjemi.uio.no.)

! Format: 6050 real indices (2x,f7.2,2x,f10.4,6(2x,f7.5))
!         6050 imaginary indices (2x,f7.2,2x,f10.4,6(1x,e11.4))

! cm-1        microns  real293, real273, real253, real223, real213, real203
! 6500.00      1.5385  1.37960  1.38950  1.38390  1.39540  1.39130  1.40310
! 6499.00      1.5387  1.37930  1.39050  1.38530  1.39570  1.39120  1.40310

! ***
! Loop over 3 input files
  do nf=1,ncomp

! Obtain the full pathname of the input ascii file
  fil=filesdat(nf)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,15
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
    nc=ntemps(nf)
   do i=1,nlines
    read(idat,*) wcmr(i,nf),wavelengthr(i,nf),(rn(i,nf,j),j=1,nc)
   end do

  do i=1,2
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmi(i,nf),wavelengthi(i,nf),(ri(i,nf,j),j=1,nc)
   end do

  end do

  close (idat)


! ***
! Write out to the screen
   nc=ntemps(mset)

   write(0,fmt=360)
   360 format(/,2x,"rdmyhre_ternary: temps(mset,i)")
   do i=1,mtempmax
    ivec1(i)=0
   end do
   do i=1,nc
    ivec1(i)=int(temps(mset,i))
   end do
   write(0,fmt=365) (ivec1(j),j=1,8)
   365 format(2x,8(1x,i4))

! Specify the temp and wghth2so4 values
  write(0,fmt=165)
  165 format(2x,"Specify temp value (e.g. 253) ")
  read(5,*) temp

    diffmin=1.0e3
    ival=-99
   do i=1,nc
   if (temps(mset,i) .gt. 10.0) then
    diff1=temps(mset,i)-temp
    a1=sqrt((diff1*diff1))
    if (a1 .lt. diffmin) then
     ival=i
     diffmin=a1
    end if
   end if
   end do

  if (ival .lt. 0) then
   write(iout,fmt=350) ival
   350 format(/,2x,"rdmyhre_ternary: ival ",1(1x,i4)," will stop")
   stop
  end if

  if (nopr .eq. 1) then
   write(iout,fmt=410) mset,ival,temps(mset,ival),filesdat(mset)
   410 format(/,2x,"rdmyhre_ternary: mset,ival,temps(mset,ival) ",/,&
   2x,2(1x,i4),1(1x,f10.4),/,&
   2x,a60)
  end if

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmr(i,mset)
   wavelength(i)=1.0e4/wcm(i)
   rndat(i)=rn(i,mset,ival)
   ridat(i)=ri(i,mset,ival)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840)
    840 format(/,2x,"rdmyhre_ternary: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
