  subroutine rdpalmer_williams_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=227,nwt=6
  real :: wghts(nwt),wh2so4(nwt)
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat,nwt),rival(ndat,nwt)
  character(len=60) :: fil
  character (len=16) :: llset,files(nwt)

! The four temperatures of interest
  wghts(1)=25.0
  wghts(2)=38.0
  wghts(3)=50.0
  wghts(4)=75.0
  wghts(5)=84.5
  wghts(6)=95.6
!         '1234567890123456'
  files(1)='PW 25% H2SO4   '
  files(2)='PW 38% H2SO4   '
  files(3)='PW 50% H2SO4   '
  files(4)='PW 75% H2SO4   '
  files(5)='PW 84.5% H2SO4 '
  files(6)='PW 95.6% H2SO4 '

! ***
! Will specify which temperature to work with

  write(0,fmt=140)
  140 format(2x," Will select iwt=1,2,3,4,5,6 for 25,38,50,75,84.5,95.6")

  write(0,fmt=160)
  160 format(2x,"Specify iwt ")

  read(5,*) iwt
  iwt=int(iwt)

  if ((iwt .lt. 1) .or. (iwt .gt. 6)) then
   write(0,fmt=165) iwt
   write(iout,fmt=165) iwt
   165 format(2x,"iwt = ",i4," wil stop")
   stop
  end if

! The compound string
  llset=files(iwt)

  write(0,fmt=170) iwt,llset
  170 format(2x," iwt,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456788012345678901234567890'
  fil='single_files/palmer_williams_h2so4.dat                      '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of refraction of sulfuric acid
!  solutions at 25, 38, 50, 75, 84.5, and 95.6% H2SO4, by weight.

!  Reference: K. F. Palmer and Dudley Williams, Optical constants of
!  sulfuric acid; Application to the clouds of Venus?, Applied Optics,
!  vol. 14, pgs. 208-219, 1975.

!  Format: 227 lines of real indices (2x,f6.0,2x,f6.3,2x,6(2x,f5.3))
!     227 lines of imaginary indices (2x,f6.0,2x,f6.3,2x,6(1x,e9.2))


!  Real indices of refraction for sulfuric acid solutions
!
!    cm-1  microns   25%    38%    50%    75%    84.5%  95.6%
!
!    400.  25.000    1.700  1.749  1.806  1.930  1.938  1.896
!    410.  24.390    1.696  1.744  1.808  1.939  1.954  1.880
!    430.  23.256    1.692  1.736  1.783  1.918  1.905  1.822

! Open the input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,16
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=227

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,6)
   end do

  do i=1,5
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,6)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iwt)
   ridat(i)=rival(i,iwt)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=839) iwt,wghts(iwt)
    839 format(/,2x,"rdpalmer_williams_h2so4: iwt,wghts(iwt) ",i4,2x,f10.4)
    write(iout,fmt=840)
    840 format(/,2x,"rdpalmer_williams_h2so4: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
