  subroutine rdposch_tio2_brookite(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=2000,ncomp=3
  integer :: noprf,mset
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! **
! The different compositions
!          '1234567890123456'
  files(1)='TiO2 Brookite x '
  files(2)='TiO2 Brookite y '
  files(3)='TiO2 Brookite z '

! **
! User will select which set to work with
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset 1,2,3 ")

  read(5,*) mset
  mset=int(mset)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
  if (mset .eq. 1) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/posch_tio2_brookite_x.dat                        '
!       '1234567890123456'
   llset='tio2 brookite x'
  end if
  if (mset .eq. 2) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/posch_tio2_brookite_y.dat                        '
   llset='tio2 brookite y'
  end if
  if (mset .eq. 3) then
!      '123456789012345678901234567890123456789012345678901234567890'
   fil='exoplanets/posch_tio2_brookite_z.dat                        '
   llset='tio2 brookite z'
  end if

   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Posch, Th., F. Kerschbaum, H. Mutschke, D. Fabian,
! D. Clément, J. Dorschner, 'Features of oxide dust particles in
! circumstellar shells of AGB stars', In: Exploiting the ISO Data
! p. 14
!
! Real and Imaginary Refractive Indices of TiO2 Brookite x
!
! Contact: Thomas Posch (thomas.posch@univie.ac.at)
!
! Format: 2000 lines 2x,2(1x,f9.2),2(1x,f10.4)
!
!       cm-1    microns     real    imaginary
!     5000.00      2.00     2.3859     0.0001
!     4980.08      2.01     2.3857     0.0001

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
    wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdposch_tio2_brookite: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdposch_tio2_brookite: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


