  subroutine rdreed_volcanic(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
! ndat  is the number of wavelengths
! ncomp is the number of compounts
  integer,parameter :: ndat=1933,ncomp=8
  integer :: i,j1,j2,mn
  real :: diff,diffmin
! Note that the ndat,ncomp is opposite to the ncdump dump
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: llset

  character(len=24) :: setsstr(ncomp)
!            '12345678901234567890'
!            '123456789012345678901234'
!            '1234567890
  setsstr(1)='        askja           '
! setsstr(1)='askja                   '
  setsstr(2)='aso                     '
  setsstr(3)='eyjafjallajokull-1      '
  setsstr(4)='eyjafjallajokull-2      '
  setsstr(5)='grimsvotn               '
  setsstr(6)='nisyros                 '
  setsstr(7)='spurr                   '
  setsstr(8)='tongariro               '

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/reed_volcanic_ash.dat                          '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***

!  Data: Real and imaginary indices of volcanic ash
!  from 528  to 25000 cm-1 for eight samples

!  askja-ash_Reed
!  aso-ash_Reed
!  eyjafjallajokull-ash_Reed_1
!  eyjafjallajokull-ash_Reed_2
!  grimsvotn-ash_Reed
!  nisyros-ash_Reed
!  spurr-ash_Reed
!  tongariro-ash_Reed

!  Reference: Reed B, Peters D, McPheat R, Grainger R.
!  The complex refractive index of volcanic ash aerosol retrieved
!  from spectral mass extinction
!  J Geophys Res 2018;123:13390
!
!  Email contact person: R. Grainger (grainger@atm.ox.ac.uk)
!
!  Format: 1933 real indices (2x,f8.2,2x,f10.4,8(2x,f5.3))
!          1933 imaginary indices (2x,f8.2,2x,f10.4,8(1x,e10.3))
!
!    cm-1       microns        real indices
!                        Asjka  Aso    Eygaf1 Eygaf2 Grim   Nisyos Spurr  Tong
!    528.00     18.9394  1.890  1.865  2.234  2.497  2.515  1.357  2.496  1.801
!    529.00     18.9036  1.867  1.783  2.219  2.387  2.418  1.366  2.497  1.810

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,25
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,ncomp)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! ****
! Will select the labooratory condition to work with
  do i=1,ncomp
   write(0,fmt=104) i,setsstr(i)
  end do
  104 format(2x,i2,2x,a24)

  write(0,fmt=140)
  140 format(2x,"Specify iset 1 to 8")
  read(5,*) iset

  write(0,fmt=165) iset
  165 format(2x," will use iset ",i2)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iset)
   ridat(i)=rival(i,iset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=835) iset,setsstr(iset)
    835 format(/,2x,i2,2x,a24)
    write(iout,fmt=840) 
    840 format(/,2x,"rdreed_volcanic: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
