  subroutine rdsinyuk_saharan_dust(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  real :: rival(nwavemax,2)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! See rdindices.f90
  character(len=16) :: llset

! Used here
  integer,parameter :: ndat=7,ncomp=2
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat)
  character(len=60) :: fil
  character(len=16) :: files(ncomp)

! *****
! The different compositions
!          '1234567890123456'
  files(1)='Sinyuk imag dust'
  files(2)='Patter imag dust'

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a40)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-2) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '12345678901234567890123456789a123456789012345678901234567890'
  fil='single_files/sinyuk_saharan_dust.dat                        '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Data: Imaginary indices of Saharan dust derived from TOMS data
! for 350 - 650 nm. Also include Patterson (1977) data in file.

! Reference: Alexander Sinyuk, Omar Torres, and Oleg Dubovik
! Combined us of satellite and surface observations to infer the
! imaginary part of refractive index of Saharan dust
! Geophys. Res. Lett., vol 30,no 2,1081, doi:10.1029/2002GL016189, 2003

! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)
! Note: values derived by ruler and pencil estimates of Fig 5 data
!
! Format: 7 lines 2x,2(1x,f8.2),2(1x,f10.4)
!         7 lines 2x,2(1x,f8.2),2(1x,f10.4)
!
!      cm-1    microns      Imaginary
!                        Sinyuk     Patterson
!  28571.43     0.35     0.0059     0.0170
!  25000.00     0.40     0.0037     0.0119
!  22222.22     0.45     0.0022     0.0096
!  20000.00     0.50     0.0015     0.0081
!  18181.82     0.55     0.0011     0.0059
!  16666.67     0.60     0.0008     0.0044
!  15384.62     0.65     0.0007     0.0033

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,17
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rival(i,j),j=1,2)
    ridat(i)=rival(i,mset)
    rndat(i)=0.00
   end do

  close (idat)

! *****
  if (nopr .eq. 1) then
   write(iout,fmt=200) mset,files(mset)
   200 format(/,2x,"rdsinyuk_saharan_dust: mset,files(mset)",/,&
   2x,i4,2x,a16)
   write(iout,fmt=230)
   230 format(2x,"rdsinyuk_saharan_dust: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
