  subroutine rdtisdale(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndat=1685,nwt=8
  integer :: i,j1,j2,mn
  real :: diff,diffmin
! Note that the ndat,nwt is opposite to the ncdump dump
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,nwt),rival(ndat,nwt)
  real :: dh,dh2so4,derivn,derivi
  character(len=60) :: fil
  character (len=16) :: llset

  real :: h2so4wt(nwt),wh2so4
  data h2so4wt/45.2,50.0,55.1,61.6,65.3,70.2,75.0,80.0/

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/tisdale_h2so4.dat                              '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of liquid H2SO4/H2O
!  at 215 K from 499 to 6996 cm-1 as a function of the
!  H2SO4 concentration by weight.

!  Reference: Tisdale, R. T., D. L. Glandorf, M. A. Tolbert,
!  and O. B. Toon, Infrared optical constants of low-temperature
!  H2SO4 solutions representative of stratospheric sulfate
!  aerosols, J. Geophys. Res., vol. 103, pgs. 25353-25370,
!  1998.

!  Email contact person: M. Tolbert (tolbert@spot.colorado.edu)
!
!  Format: 1685 real indices (2x,f7.2,2x,f10.4,8(2x,f5.3))
!          1685 imaginary indices (2x,f7.2,2x,f10.4,8(1x,e10.3))
!
!   cm-1       microns                        real indices
!                       45.2%  50%    55.1%  61.6%  65.3%  70.2%  75%    80%
!   499.50     20.0200  1.989  2.013  2.032  2.067  2.098  2.100  2.103  2.089
!   503.30     19.8689  1.887  1.905  1.920  1.958  1.992  2.000  2.013  2.005

! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,18
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=1685

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,8)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,8)
   end do

  close (idat)

! ****
! Specify the weight percent h2so4
   write(0,fmt=130)
   130 format(/,2x,"The weight percent h2so4 values to choose from")
  do i=1,nwt
   write(0,fmt=135) h2so4wt(i)
   135 format(2x,f10.4)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify wh2so4 ")

  read(5,*) wh2so4

! The compound string
!       '1234567890123456'
  llset=' Tisdale H2SO4  '

  write(0,fmt=170) wh2so4
  170 format(2x," wh2so4 ",f10.4)

! *****
! Find the indices for the interpolation
   j1=-99
   j2=-99
    dh=0.0
   if (wh2so4 .lt. h2so4wt(1)) then
    j1=1
    j2=2
    dh=wh2so4-h2so4wt(1)
    go to 600 
   end if
   if (wh2so4 .gt. h2so4wt(nwt)) then
    j1=nwt-1
    j2=nwt
    dh=wh2so4-h2so4wt(1)
    go to 600 
   end if
  do i=1,nwt-1
    i2=i+1
   if ((wh2so4 .ge. h2so4wt(i)) .and. (wh2so4 .lt. h2so4wt(i2))) then
    j1=i
    j2=i2
    dh=wh2so4-h2so4wt(i)
    go to 600 
   end if
  end do
  600 mn=0

! Check
  if ((j1 .le. 0) .or. (j2 .le. 0)) then 
   write(0,fmt=610)
   610 format(2x,"j1 or j2 le 0, will stop")
   stop
  end if

! Put values into the output arrays
   dh2so4=h2so4wt(j2)-h2so4wt(j1)
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   derivn=(rnval(i,j2)-rnval(i,j1))/dh2so4
   derivi=(rival(i,j2)-rival(i,j1))/dh2so4
   a1=rnval(i,j1)+(dh*derivn)
   a2=rival(i,j1)+(dh*derivi)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   rndat(i)=a1
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840) wh2so4,j1,j2,h2so4wt(j1),h2so4wt(j2),dh
    840 format(/,2x,"rdtisdale:  wh2so4,j1,j2,h2so4wt(j1),h2so4wt(j2),dh ",/,&
    2x,f10.4,2(1x,i3),3(1x,f10.4),/,&
    2x,"rdtisdale: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end

