  subroutine rdtoon_minerals(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=112,ncomp=3
  integer :: noprf,mset,i1,i2
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/toon_mont_granite.dat                          '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Mont 219        '
  files(2)='Mont 222        '
  files(3)='Granite         '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-3) e.g. mset=3 for Granite ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! *****
!
! Data: Real and imaginary indices of Montmorillonite and Granite
! from 250 to 2000 cm-1

! Reference: Toon, O. B., J. B. Pollack, C. Sagan
! Physical Properties of the Particles Composing
! the Martian Dust Storm of 1971 - 1972
! Icarus, vol 30, 663-696, 1977

! Contact: Brian Toon, btoon@lasp.colorado.edu
!
! Format: 112 lines 2x,2(1x,f8.2),3(1x,f10.4)
!         112 lines 2x,2(1x,f8.2),3(1x,f10.4)
!
!      cm-1    microns               Real
!                        Mont219    Mont222    Granite
!    250.00    40.00     2.1800     2.1800     2.4300
!    260.00    38.50     2.1800     2.1700     2.4300

! ***
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,16
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rnval(i,j),j=1,ncomp)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdtoon_minerals: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdtoon_minerals: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
