  subroutine rdtoon_psc(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=500,ncomp=8
  integer :: noprf,mset
  real :: wcmdat(ndat,ncomp),wavedat(ndat,ncomp),rnval(ndat,ncomp),rival(ndat,ncomp)
  integer :: nlinesj(ncomp)
  character(len=60) :: fil
  character(len=80) :: header
  character (len=16) :: files(ncomp),llset

  data nlinesj/110, 133, 112, 135, 173, 120, 113, 124 /

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/toon_psc.dat                                   '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
!
!  Data: Real and imaginary indices of refraction of H2O-ice, amorphous
!  nitric acid solutions, and nitric acid hydrates.

!  Reference: O. B. Toon, M. A. Tolbert, B. G. Koehler, A. M. Middlebrook,
!  and J. Jordan, The infrared optical constants of H2O-ice, amorphous
!  acid solutions, and nitric acid hydrates, J. Geophys. Res., accepted
!  for publication, 1994.

!  Format: wavenumber(cm-1), real index,imaginary index
!   110 lines, BETA NAT film  at 196 K
!   133 lines, NAD film at 184 K
!   112 lines, ALPHA NAT film at 181 k
!   135 lines, NAM film at 179 K
!   173 lines, water ice film at 163 K
!   120 lines, A NAT film at 153 K
!   113 lines, A NAD film at 153 K
!   124 lines, A NAM film at 153 K
!  2x,f6.1,2x,f5.3,2x,e8.2


!  BETA NAT film at 196 K
!   110    2x,f6.1,2x,f5.3,2x,e8.2
!   cm-1   n      k
!   482.0  1.950  2.22E-01
!   494.0  1.832  2.54E-01

! read in all of the data
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,20
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do j=1,ncomp

   nskip=4
  do i=1,nskip
   read(idat,fmt=100) header
  end do

   nlines=nlinesj(j)
  do i=1,nlines
   read(idat,*) wcmdat(i,j),rnval(i,j),rival(i,j)
   wavedat(i,j)=1.0e4/wcmdat(i,j)
  end do

  end do

  close (idat)

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Beta NAT        '
  files(2)='NAD             '
  files(3)='Alpha NAT       ' 
  files(4)='NAM             '
  files(5)='Ice 163 K       '
  files(6)='A NAT           '
  files(7)='A NAD           '
  files(8)='A NAM           '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-8) e.g. mset=1 for Beta NAT ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ****
! Put values into the output arrays
   nlines=nlinesj(mset)
  do i=1,nlines
   wcm(i)=wcmdat(i,mset)
   wavelength(i)=wavedat(i,mset)
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdtoon_psc: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdtoon_psc: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
