  subroutine rdwagner_sahara_dust(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=14,ncomp=5
  integer :: noprf,mset,i1,i2
  real :: hematite(ncomp)
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: files(ncomp)
  character (len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/wagner_sahara_dust.dat                         '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Wagner Bakina Fa'
  files(2)='Wagner Cairo 2  '  
  files(3)='Wagner SANUM B1 '
  files(4)='Wagner SANUM B2 '
  files(5)='Wagner SANUM B3 ' 

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific case")
  write(0,fmt=145)
  145 format(2x," i, case ")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a40)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-5) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! *****
! Specify how many lines to work with
  nlines=ndat

  write(0,fmt=700) nlines
  write(iout,fmt=700) nlines
  700 format(/,2x,"nlines ",i4)

! *****
! Data: Imaginary indices of Saharan dust samples for five locations
! with hematite between 1 and 3 % by volume for 305 - 955 nm

! Reference: R. Wagner, T. Ajtai, K. Kandler, K. Lieke, C. Linke,
! T. Muller, M. Schnaiter, and N. Vragel. Complex refractive indices
! of Saharan dust samples at visible and near UV wavelengths: a
! laboratory study. Atmos. Chem. Phys., 12, 2491-2512, 2012.

! Email contact person: R. Wagner (robert.wagner2@kit.edu)
! iset
! 0 Wagner Bakina Faso
! 1 Wagner Cairo 2
! 2 Wagner SANUM B1
! 3 Wagner SANUM B2
! 4 Wagner SANUM B3

! Format: 14 lines 2x,2(1x,f8.2),5(1x,f10.4)
!         14 lines 2x,2(1x,f8.2),5(1x,f10.4)
!
!      cm-1    microns                          Real
!                        Bakina     Cairo      SANUM1     SANUM2     SANUM3
!  32786.88     0.31     1.5300     1.5300     1.5300     1.5300     1.5300
!  28169.01     0.36     1.5300     1.5300     1.5300     1.5300     1.5300
!  24691.36     0.41     1.5300     1.5300     1.5300     1.5300     1.5300

! *****
! Read in all of the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,22
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rnval(i,j),j=1,ncomp)
   end do

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),(rival(i,j),j=1,ncomp)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset),hematite(mset)
    800 format(/,2x,"rdwagner_sahara_dust: work with mset, files(mset)",/,&
    2x,i3,2x,a16,/,&
    2x,"rdwagner_sahara_dust: hematite(mset) ",f10.4)
    write(iout,fmt=840)
    840 format(2x,"rdwagner_sahara_dust: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
