! **********************************************************************
  subroutine rdwork(noprwork,&
  noprtest,noprlist,noprind,&
  noprwave,noprsize,noprext,&
  iout,indir,outdir,fout,&
  itest,iset,&
  iwrind,iwrsize,iwrext,&
  iwave,w1,w2,dw,r1,r2,&
  den1,rad1,sig1,&
  den2,rad2,sig2,&
  icompare,iset1,iset2,&
  imix,imix1,imix2)
 
! *****
! See rdinoudir.f90 and main.f90
  integer :: nopr,iout
  character(len=5) :: fout
  character(len=60) :: indir,outdir

! See rdwork.f90
  integer :: noprwork,noprtest,noprlist,noprind,noprwave,noprsize,noprext
  integer :: itest,iset,iwrind,iwrsize,iwrext
  integer :: iwave
  real :: w1,w2,dw
  real :: r1,r2
  real :: den1,rad1,sig1
  real :: den2,rad2,sig2
  integer :: icompare,iset1,iset2
  integer :: imix,imix1,imix2

! Use here
  integer :: idat
  character(len=8) :: file
  character(len=80) :: header
  character(len=80) :: blankline

! ************************
! Output 

! Test the routine with itest=1
! iset specifies the index of reafraction set to work with
! iwave=1 for wavenumber scale, iwave=2 for wavelength scale

! To compare two sets of indices, icompare=1
! The two sets are iset1,iset2
! Will write out to an output ascii file 

! To compare mixing rules for multi-component species, imix=1
! Will write out to ascii file

! Will write out to ascii files, the indices, size distribution
! and the spectra with these flags set to 1
! Write out indices            by setting iwrind=1
! Write out size distribution  by setting iwrsize1
! Write out extinction etc     by setting iwrext=1

! Print flags for the various routines (1 to print, 0 not to print)
! noprwork, noprtest, noprlist, noprind, noprsize, noprext

! *************************
! The   work.dat  ascii file has specifications for the work to be done
!       '12345678'
   file='work.dat'

    idat=30
! Open the ascii file
  open(idat,form='formatted',file='work.dat',status='unknown')

! *************************
! Read in the data
  read(idat,fmt=100) header
  read(idat,fmt=*) itest
  read(idat,fmt=100) blankline

  100 format(a80)
  110 format(i4)

  read(idat,fmt=100) header
  read(idat,fmt=*) icompare
  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=*) iset1,iset2
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header
  read(idat,fmt=*) imix
  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=*) imix1,imix2
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=*) iset
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header
  read(idat,fmt=*) iwave
  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=*) w1,w2,dw
  read(idat,fmt=100) blankline

! 130 format(3(*))
! 140 format(2(*))

  read(idat,fmt=100) header
  read(idat,fmt=100) header
  read(idat,fmt=*) den1,rad1,sig1
  read(idat,fmt=100) header
  read(idat,fmt=*) den2,rad2,sig2
  read(idat,fmt=100) header
  read(idat,fmt=*) r1,r2
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header
  read(idat,fmt=*) iwrind
  read(idat,fmt=100) header
  read(idat,fmt=*) iwrsize
  read(idat,fmt=100) header
  read(idat,fmt=*) iwrext
  read(idat,fmt=100) blankline

  read(idat,fmt=100) header
  read(idat,fmt=*) noprwork
  read(idat,fmt=100) header
  read(idat,fmt=*) noprtest
  read(idat,fmt=100) header
  read(idat,fmt=*) noprlist
  read(idat,fmt=100) header
  read(idat,fmt=*) noprind
  read(idat,fmt=100) header
  read(idat,fmt=*) noprwave
  read(idat,fmt=100) header
  read(idat,fmt=110) noprsize
  read(idat,fmt=100) header
  read(idat,fmt=110) noprext

! Close the directory.dat file
   close (idat)

! *************************
! Write out to the output ascii file
  if (noprwork .eq. 1) then 

  write(iout,fmt=200)
  200 format(2x)

  write(iout,fmt=210) iset
  210 format(2x,"rdwork: index iset ",i4)

  write(iout,fmt=200)
  write(iout,fmt=220)
  write(iout,fmt=230)
  write(iout,fmt=240) icompare,iset1,iset2
  220 format(2x,"rdwork:  will compare sets of indices if icompare=1")
  230 format(2x,"rdwork:  icompare,iset1,iset2 ")
  240 format(2x,3(1x,i4))

  write(iout,fmt=200)
  write(iout,fmt=250)
  write(iout,fmt=260)
  write(iout,fmt=270) imix,imix1,imix2
  250 format(2x,"rdwork:  will compare mixing rules if imix=1 ")
  260 format(2x,"rdwork:  imix,imix1,imix2 ")
  270 format(2x,3(1x,i4))

  write(iout,fmt=200)
  write(iout,fmt=280)
  write(iout,fmt=290) iwave
  280 format(2x,"rdwork:  iwave=1,2 for wavenumber or wavelength grid ")
  290 format(2x,"rdwork:  iwave ",i4)
  if (iwave .eq. 1) then 
   write(iout,fmt=310) 
   310 format(2x,"rdwork: w1,w2,dw are in wavenumbers")
  end if
  if (iwave .eq. 2) then
   write(iout,fmt=320) 
   320 format(2x,"rdwork: w1,w2,dw are in microns")
  end if
  write(iout,fmt=330) w1,w2,dw
  330 format(2x,"rdwork: w1,w2,dw ",3(1x,f10.4))

  write(iout,fmt=200)
  write(iout,fmt=340)
  write(iout,fmt=350) iwrind
  write(iout,fmt=360)
  write(iout,fmt=370) iwrsize
  write(iout,fmt=380)
  write(iout,fmt=390) iwrext

  340 format(2x,"rdwork:  write out indices to ascii output files")
  350 format(2x,"rdwork:  iwrind ",i4)
  360 format(2x,"rdwork:  write size distribution to files")
  370 format(2x,"rdwork:  iwrsize ",i4)
  380 format(2x,"rdwork:  write out spectra to ascii output files")
  390 format(2x,"rdwork:  iwrext ",i4)

  write(iout,fmt=200)
  write(iout,fmt=400)
  write(iout,fmt=410)
  write(iout,fmt=420)
  write(iout,fmt=430) noprwork,noprtest,noprlist,noprind
  write(iout,fmt=440)
  write(iout,fmt=450) noprwave,noprsize,noprext

  400 format(2x,"rdwork:  will write out to the f.out ascii file when")
  410 format(2x,"rdwork:  the print flags are set to 1")
  420 format(2x,"rdwork:  noprwork, noprtest, noprlist, noprind ")
  430 format(2x,4(1x,i4))
  440 format(2x,"rdwork:   noprwave, noprsize, noprext ")
  450 format(2x,3(1x,i4))

   end if

! *****
  return
  end
