  subroutine wrindices_interp(nopr,iout,outdir,&
  nlines,wave,rn,ri,iwave,&
  lset)

! *************************
  include 'param1.inc'

! See rdinoutdir.f90
  character(len=60) :: outdir

! See rdwork.f90
  integer :: nopr,iout
  integer :: iwave

! See getfilnm30.f90
  character(len=30) :: fil
  character(len=100) :: filnm

! Used here
  integer :: idat

! See wrindices_interp.f90
  character(len=100) :: lset
  real :: wave(nwavemax)
  real :: rn(nwavemax),ri(nwavemax)

! *************************
! The output ascii file is specified
!     '123456789012345678901234567890'
  fil='indices_interp.ascii          '

   noprf=1
  call getfilnm30(noprf,iout,fil,outdir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! *************************
! Open the output ascii file for the refractive indices
   idat=30
  open(idat,form='formatted',file=filnm,status='unknown')

! **************************
! Write out to the output ascii file
  write(idat,fmt=90) lset
  90 format(2x,a100)

  write(idat,fmt=95) nlines
  95 format(2x,"Number of lines",/,2x,i5)

  write(idat,fmt=100) 
  100 format(2x,"i,wave,rn,ri,")
   do i=1,nlines 
    write(idat,fmt=110) i,wave(i),rn(i),ri(i)
    110 format(1(2x,i4,","),2(1x,f12.4,","),1p,2(1x,e10.3,","))
   end do

! *************************
! Close the output ascii file
!  print,'  wrindices: wrote to ',filnm
!  write(0),"  wrindices: wrote to output ascii file"
   close (idat)

! *************************
  return
  end
