   pro bruggeman,iout,m1,m2,f2,m3

;-----------------------------------------------------------
;
; routine uses the Bruggeman relation to 
; find the refractive index of a mixture of two substances.
;
; Input:
;   m1......complex refractive index of substance 1 (main matrix substance)
;   m2......complex refractive index of substance 2 (inclusions)
;   f2......volume fraction of substance 2 (the inclusions)
;
; Output:
;   m3...complex refractive index of mixture
;
; source:  see page 217 of Bohren and Huffman, "Absorption and
;          Scattering of Light by Small Particles".
;   f2 (m2-m3)/(m2+2*m3)  +   (1-f2) (m1-m3)/(m1+2*m3) = 0
;
;-----------------------------------------------------------
; See  BRUGG(F1, F2, EPS1, EPS2, EPS3, EPSAVG) from
; Prof Grant Petty
; http://rime.aos.wisc.edu/MW/models/mixing.shtml

;  Variable and parameter descriptions:
;     F1      = volume fraction of component 1
;     F2      = volume fraction of component 2
;     1-F1-F2 = volume fraction of component 3
;     F       = volume fraction of inclusion.
;
;     EPS1    = dielectric constant of component 1
;     EPS2    = dielectric constant of component 2
;     EPS3    = dielectric constant of component 3
;     EPSAVG  = averaged dielectric constant
;     verified both multiply 0.5 and divide by 2.0 are correct

;     B = ((1.0D0 - 3.0*(1.0D0 - F))*EPS2 + (1.0D0 - 3.0*F)*EPS1)/2.0
;     EPSAVG0 = (-0.5*B) + 0.5*(B*B + 2.0*EPS2*EPS1)**0.5
;     F = (F1 + F2)/1.0D0
;     B = ((1.0D0 - 3.0*(1.0D0 - F))*EPS3 + (1.0D0 - 3.0*F)*EPSAVG0)/2.0
;     EPSAVG = (-0.5*B) + 0.5*(B*B + 2.0*EPS3*EPSAVG0)**0.5

      b = ((1.0 - 3.0*(1.0 - f2))*m1 + (1.0D0 - 3.0*f2)*m2)/2.0
      m3a = (-0.5*b) + 0.5*(b*b + 2.0*m1*m2)^0.5

; Seems to work !
; To see the math (compare 3 solution methods, comment out the return)
      m3=m3a

      return
; *****
; Your math
      del1=1.00-f2
      del2=f2
      a=-2.0
      b=(del1*((2.0*m1)-m2))+(del2*((2.0*m2)-m1))
      c=m1*m2
      disc=(b*b)-(4.0*a*c)
      m3b=((-1.0*b)-sqrt(disc))/(2.0*a)

;-----------------------------------------------------------
; Define complex numbers used in the calculation
    a1=1.00-f2
; check !!
   b1=complex(a1,0.0)
   b2=complex(f2,0.0)
   c2=complex(2.00,0.0)
;  b1=complex(a1,a1)
;  b2=complex(f2,f2)
;  c2=complex(2.0,2.0)

; Make sure these are complex
   m3=complex(1.0,1.0)
   d1=complex(1.0,1.0)
   d2=complex(1.0,1.0)
   m3old=complex(1.0,1.0)
   fac1=complex(1.0,1.0)
   fac2=complex(1.0,1.0)
   a1=complex(1.0,1.0)
   a2=complex(1.0,1.0)
   diff=complex(1.0,1.0)

; To start the iterations, obtain an estimate of m3 using the volume average
   m3=(b1*m1) + (b2*m2)
   d1=m2+c2*m3
   d2=m1+c2*m3
   m3old=m3

; See how the iterations go
    iwr=1
   if (iwr eq 1) then begin   
    printf,iout,'  '
    printf,iout,'  bruggeman: m3 is the mixture indices'
    printf,iout,'  bruggeman: diff is difference in each iteration'
    printf,iout,'  bruggeman: diffabs is scalar of absolute difference'
    printf,iout,'  bruggeman: m3,diff,diffabs'
   endif

; Iterate for nterms
; Will say you got the answer if diffabs is less than diffeps
    diffeps=1.0e-6
    nterms=30
   for i=0,nterms do begin
    fac1=b2*d2
    fac2=b1*d1
    a1=(fac1*m2)+(fac2*m1)
    a2=fac1+fac2
    m3=a1/a2
    m3new=m3
    d1=m2+(c2*m3)
    d2=m1+(c2*m3)
    diff=m3new-m3old
    m3old=m3new
    diffabs=abs(diff)
    if (iwr eq 1) then begin   
     printf,iout,i,m3,diff,diffabs
    endif
    if (diffabs lt diffeps) then begin
     goto,jump1
    endif
   endfor
   jump1:mn=0


   if (iwr eq 1) then begin   
    printf,iout,'  '
    printf,iout,'  bruggeman: m3 ',m3
    printf,iout,'  bruggeman: m3a ',m3a
    printf,iout,'  bruggeman: m3b ',m3b
    stop
   endif
    
; *****
   return
   end

