  pro calcsized,nopr,iout,$
  r1,r2,$
  den1,rad1,sig1,$
  den2,rad2,sig2,$
  ndist,radr,sized,$
  outdir,igraphd,iwrsize,$
  lset

; *************************
  r1log=alog(r1)
  r2log=alog(r2)

  ndist2=200

  pi=3.14159265
  const=sqrt(2.0*pi)

   s1=alog(sig1)
  if (sig2 gt 1.0) then begin
   s2=alog(sig2)
  endif
  if (sig2 lt 1.0) then begin
   den2=0.0
  endif

  dlog=(r2log-r1log)/(1.00*ndist2)

; Output
  radr2=fltarr(ndist2)
  sized2=fltarr(ndist2)

; Calculate the size distribution
  for i=0,ndist2-1 do begin

   term1=0.0
   term2=0.0

   rlog=r1log+(i*dlog)
   radr2(i)=exp(rlog)

   if (den1 ge 1.0e-6) then begin
    alpha1=(alog(radr2(i)/rad1))/s1
    a2=(alpha1*alpha1)/2.0
    term1=den1*(1.0/(radr2(i)*s1*const))*exp(-a2)
   endif
   if (den2 ge 1.0e-6) then begin
    alpha2=(alog(radr2(i)/rad2))/s2
    a4=(alpha2*alpha2)/2.0
    term2=den2*(1.0/(radr2(i)*s2*const))*exp(-a4)
   endif

    sum=term1+term2
   sized2(i)=sum

  endfor

; The units of the size distribution are 
;   number of particles per cm3 per micron
; with the per micron refers to the radii increment in radius

; *************************
; Just use values that are greater than 1.0e-12

; **
    ifirst=-99
   for i=0,ndist2-1 do begin
    if (sized2(i) ge 1.0e-12) then begin
     ifirst=i
     goto,jump1
    endif
   endfor
   jump1:mn=0

; **
    i1=ndist2-1
    i2=0
    iskip=-1
    ilast=-99
   for i=i1,i2,iskip do begin
    if (sized2(i) ge 1.0e-12) then begin
     ilast=i
     goto,jump2
    endif
   endfor
   jump2:mn=0

; **
; Redefine the size distribution
    iok=0
   if ((ifirst ge 0) and (ilast ge 0)) then begin
     iok=1
    ndist=ilast-ifirst+1
    radr=fltarr(ndist)
    sized=fltarr(ndist)
     j=-1
    for i=ifirst,ilast do begin
     j=j+1
     radr(j)=radr2(i)
     sized(j)=sized2(i)
    endfor
   endif

; *************************
  if (nopr eq 1) then begin
   printf,iout,'  '
   printf,iout,'  calcsized: the size distribution is defined for the'
   printf,iout,'  calcsized: r1 to r2 range in microns'
   printf,iout,'  calcsized: r1,r2 ',r1,r2
   printf,iout,'  calcsized: den1,rad1,sig1 ',den1,rad1,sig1
   printf,iout,'  calcsized: den2,rad2,sig2 ',den2,rad2,sig2
   printf,iout,'  calcsized: radr is in microns'
   printf,iout,'  calcsized: sized = number per cm3 per micron radius increment'
   printf,iout,'  calcsized: i,radr(i),sized(i)'
   i1=0
   i2=ndist-1
   iskip=i2/20
   for i=0,ndist-1,iskip do begin
    printf,iout,'  ',i,radr(i),sized(i)
   endfor
  endif

; *************************
  if (iwrsize eq 1) then begin
   wrsize,nopr,iout,outdir,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   lset
  endif

; *************************
; Graph the results
   if (igraphd eq 1) then begin

; The output ps graphics file
    fileps=strcompress(outdir+'gsized.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

      ngraphs=1
     titles=strarr(ngraphs)
     titles=['Size Distribution (# particles per cm3 per micron)']

     xvec=fltarr(ndist)
     yvec=fltarr(ndist)
     isym=intarr(ndist)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,ndist-1 do begin
       xvec(i)=radr(i)
       yvec(i)=sized(i)
       isym(i)=4
      endfor

    labelx='Radius (microns)'
    labely=titles(ii)
    title=labely

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=1
    iylog=1
    ioplot=1

    graphxy,iout,xvec,yvec,isym,ndist,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs (one size distribution)

; Close the output ps graphics file
    print,' calcsized: wrote to ',fileps
    device,/close

   endif
; *************************
  return
  end
