  pro calcwave,nopr,iout,$
  nlines,wcm,wavelength,rndat,ridat,$
  iwave,w1,w2,dw,$
  nwave,wave,rn,ri,$
  outdir,igraphi,iwrind,lset,lstrn,$
  ibothpos

; *************************
  if (nlines eq 1) then begin
   print,'  '
   print,'  calcwave: there is only one wavelength'
     nwave=nlines
    wave=fltarr(nwave)
    rn=fltarr(nwave)
    ri=fltarr(nwave)
    rn(0)=rndat(0)
    ri(0)=ridat(0)
   if (iwave eq 2) then begin
    wave(0)=wavelength(0)
   endif
   if (iwave eq 1) then begin
    wave(0)=wcm(0)
   endif
   goto,jump10
  endif

; *************************
; For wavenumber scale
  if (iwave eq 1) then begin

; Check that wavenumbers are OK
    if ((w1 lt 100.0) or (w2 lt 100.0)) then begin
     print,'  '
     print,'  iwave=1, expect w1 and w2 to be ge 100.0 cm-1 '
     print,'  Will stop in calcwave'
     stop
    endif

; There will be nwave spectral points in the extinction spectrum
     a1=(w2-w1)/dw
     nwave=fix(a1)
    wave=fltarr(nwave)
    rn=fltarr(nwave)
    ri=fltarr(nwave)

; Wave is in wavenumbers
    for i=0,nwave-1 do begin
     wave(i)=w1+(i*dw)
    endfor

; wavenumber increases from wcm(0) to wcm(1)
    if (wcm(1) ge wcm(0)) then begin
     iorder=1
     j1=0
     j2=nlines-1
     jskip=1
      ioops=0
     if (wcm(0) gt wave(0)) then begin
      ioops=1
     endif
     if (wave(nwave-1) gt wcm(nlines-1)) then begin
      ioops=1
     endif
    endif

; wavenumber decreases from wcm(0) to wcm(1)
    if (wcm(0) ge wcm(1)) then begin
     iorder=2
     j2=0
     j1=nlines-1
     jskip=-1
      ioops=0
     if (wcm(nlines-1) gt wave(0)) then begin
      ioops=1
     endif
     if (wave(nwave-1) gt wcm(0)) then begin
      ioops=1
     endif
    endif

    if (ioops eq 1) then begin
     printf,iout,'  '
     printf,iout,'  calcwave: refractive index set does not have data'
     printf,iout,'  calcwave: for the full wave grid'
     printf,iout,'  calcwave: iwave ',iwave
     printf,iout,'  calcwave: wave(0),wave(nwave-1)'
     printf,iout,'  ',wave(0),wave(nwave-1)
     printf,iout,'  calcwave: wcm(0),wcm(nlines-1)'
     printf,iout,'  ',wcm(0),wcm(nlines-1)
     printf,iout,'  calcwave: wavelength(0),wavelength(nlines-1)'
     printf,iout,'  ',wavelength(0),wavelength(nlines-1)
     stop
    endif

; **
; Loop over the output grid wave with nwave points
   for i=0,nwave-1 do begin

; **
; wavenumber increases as j increases 
    if (iorder eq 1) then begin

      iok=0
     for j=j1,j2,jskip do begin
      if (wcm(j) gt wave(i)) then begin
       iok=1
       i1=j-1
       i2=j
       j1=i1
       dw2=wave(i)-wcm(i1)
       goto,jump1
      endif
     endfor
     jump1:mn=0

     if (iok eq 1) then begin
      dwd=wcm(i2)-wcm(i1)
      deriv1=(rndat(i2)-rndat(i1))/dwd
      deriv2=(ridat(i2)-ridat(i1))/dwd
       a1=rndat(i1)+(deriv1*dw2)
      if (a1 lt 0.0) then begin
       a1=0.0
      endif
       a2=ridat(i1)+(deriv2*dw2)
      if (a2 lt 0.0) then begin
       a2=0.0
      endif
      rn(i)=a1
      ri(i)=a2
     endif
     
    endif
; iorder=1

; **
; wavenumber decreases
    if (iorder eq 2) then begin

      iok=0
     for j=j1,j2,jskip do begin
      if (wcm(j) gt wave(i)) then begin
       iok=1
       i1=j
       i2=j+1
       j1=i2
       dw2=wave(i)-wcm(i2)
       goto,jump2
      endif
     endfor
     jump2:mn=0

     if (iok eq 1) then begin
      dwd=wcm(i2)-wcm(i1)
      deriv1=(rndat(i2)-rndat(i1))/dwd
      deriv2=(ridat(i2)-ridat(i1))/dwd
       a1=rndat(i2)+(deriv1*dw2)
      if (a1 lt 0.0) then begin
       a1=0.0
      endif
       a2=ridat(i2)+(deriv2*dw2)
      if (a2 lt 0.0) then begin
       a2=0.0
      endif
      rn(i)=a1
      ri(i)=a2
     endif
     
    endif
; iorder=1

   endfor
; loop over nwave wave

  endif
; iwave=1

; *************************
; For wavelength scale
  if (iwave eq 2) then begin

; Check that wavelengths are OK
    if ((w1 ge 100.0) or (w2 ge 100.0)) then begin
     print,'  '
     print,'  iwave=2, expect w1 and w2 to be le 100.0 microns'
     print,'  Will stop in calcwave'
     stop
    endif

; There will be nwave spectral points in the extinction spectrum
     a1=(w2-w1)/dw
     nwave=fix(a1)
    wave=fltarr(nwave)
    rn=fltarr(nwave)
    ri=fltarr(nwave)

; Wave is in microns
    for i=0,nwave-1 do begin
     wave(i)=w1+(i*dw)
    endfor

; Check end points

; wavelength increases from wavelength(0) to wavelength(1)
    if (wavelength(1) ge wavelength(0)) then begin
     iorder=1
     j1=0
     j2=nlines-1
     jskip=1
      ioops=0
     if (wave(0) lt wavelength(0)) then begin
      ioops=1
     endif
     if (wave(nwave-1) gt wavelength(nlines-1)) then begin
      ioops=1
     endif
    endif

; wavelength decreases from wavelength(0) to wavelength(1)
    if (wavelength(0) ge wavelength(1)) then begin
     iorder=2
     j2=0
     j1=nlines-1
     jskip=-1
      ioops=0
     if (wave(0) lt wavelength(nlines-1)) then begin
      ioops=1
     endif
     if (wave(nwave-1) gt wavelength(0)) then begin
      ioops=1
     endif
    endif

    if (ioops eq 1) then begin

     print,'  '
     print,'  calcwave: refractive index set does not have data'
     print,'  calcwave: for the specified wave grid, will stop'
     print,'  calcwave: specified wave(0),wave(nwave-1)'
     print,'  ',wave(0),wave(nwave-1)
     print,'  calcwave: data wcm(0),wcm(nlines-1)'
     print,'  ',wcm(0),wcm(nlines-1)
     print,'  calcwave: data wavelength(0),wavelength(nlines-1)'
     print,'  ',wavelength(0),wavelength(nlines-1)
     print,'  '

     printf,iout,'  '
     printf,iout,'  calcwave: refractive index set does not have data'
     printf,iout,'  calcwave: for the specified wave grid, will stop'
     printf,iout,'  calcwave: iwave ',iwave
     printf,iout,'  calcwave: specified wave(0),wave(nwave-1)'
     printf,iout,'  ',wave(0),wave(nwave-1)
     printf,iout,'  calcwave: data wcm(0),wcm(nlines-1)'
     printf,iout,'  ',wcm(0),wcm(nlines-1)
     printf,iout,'  calcwave: data wavelength(0),wavelength(nlines-1)'
     printf,iout,'  ',wavelength(0),wavelength(nlines-1)
     printf,iout,'  '

     stop
    endif

; **
; Loop over the output grid wave with nwave points
   for i=0,nwave-1 do begin

; **
; wavelength increases as j increases
    if (iorder eq 1) then begin

      iok=0
     for j=j1,j2,jskip do begin
      if (wavelength(j) gt wave(i)) then begin
       iok=1
       i1=j-1
       i2=j
       if (i1 lt 0) then begin
        stop
       endif
       j1=i1
       dw2=wave(i)-wavelength(i1)
       goto,jump3
      endif
     endfor
     jump3:mn=0

     if (iok eq 1) then begin
      dwd=wavelength(i2)-wavelength(i1)
      deriv1=(rndat(i2)-rndat(i1))/dwd
      deriv2=(ridat(i2)-ridat(i1))/dwd
       a1=rndat(i1)+(deriv1*dw2)
      if (a1 lt 0.0) then begin
       a1=0.0
      endif
       a2=ridat(i1)+(deriv2*dw2)
      if (a2 lt 0.0) then begin
       a2=0.0
      endif
      rn(i)=a1
      ri(i)=a2
     endif
     
    endif
; iorder=1

; **
; wavelength decreases 
    if (iorder eq 2) then begin

      iok=0
     for j=j1,j2,jskip do begin
      if (wavelength(j) gt wave(i)) then begin
       iok=1
       i1=j
       i2=j+1
       j1=i2
       dw2=wave(i)-wavelength(i2)
       goto,jump4
      endif
     endfor
     jump4:mn=0

     if (iok eq 1) then begin
      dwd=wavelength(i2)-wavelength(i1)
      deriv1=(rndat(i2)-rndat(i1))/dwd
      deriv2=(ridat(i2)-ridat(i1))/dwd
       a1=rndat(i2)+(deriv1*dw2)
      if (a1 lt 0.0) then begin
       a1=0.0
      endif
       a2=ridat(i2)+(deriv2*dw2)
      if (a2 lt 0.0) then begin
       a2=0.0
      endif
      rn(i)=a1
      ri(i)=a2
     endif
     
    endif
; iorder=2
; **

   endfor
  endif

; *************************
; For case with one wavelength
  jump10:mn=0

; *************************
   if (nopr eq 1) then begin
    printf,iout,'  '
    printf,iout,'  calcwave: i,wave(i),rn(i),ri(i)'
    for i=0,nwave-1 do begin
     printf,iout,'  ',i,wave(i),rn(i),ri(i)
    endfor
   endif

; *************************
; Write out the interpolated indices to ascii and netCDF files
   if (iwrind eq 1) then begin
    wrindices,nopr,iout,outdir,$
    nwave,wave,rn,ri,iwave,$
    lset
   endif

; *************************
; Graph the results
   if (igraphi eq 1) then begin

; The output ps graphics file
    fileps=strcompress(outdir+'gindex.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

      ngraphs=2
     titles=strarr(ngraphs)
     titles=['Real Index ','Imaginary Index']

      arrays=fltarr(nwave,ngraphs)
     for i=0,nwave-1 do begin
      arrays(i,0)=rn(i)
      arrays(i,1)=ri(i)
     endfor

     xvec=fltarr(nwave)
     yvec=fltarr(nwave)
     isym=intarr(nwave)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,nwave-1 do begin
       xvec(i)=wave(i)
       yvec(i)=arrays(i,ii)
       isym(i)=4
      endfor

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif
    labely=titles(ii)
    title=lset

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=0
    iylog=0
    ioplot=1

    graphxy,iout,xvec,yvec,isym,nwave,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs

; Close the output ps graphics file
    print,' calcwave: wrote to ',fileps
    device,/close

   endif

; *************************
  if (ibothpos eq 0) then begin
   print,'  '
   print,'  calcwave: ibothpos=0, real or imaginary indices are zero, will stop'
   printf,iout,'  calcwave: ibothpos=0, real or imaginary indices are zero, will stop'
   stop
  endif

; *************************
  return
  end
