  pro compare_spectra,nopr,iout,$
  dircompare,$
  icompare_spectra

; *************************
; Read in the two ascii files to read 
   
  filnm=strarr(1)
  filnm=strcompress(dircompare+'compare_spectra.dat')
  print,filnm

; The output ps graphics file
   fileps=strcompress(dircompare+'spectra.ps')

; Open the output ps file
   set_plot, 'ps'
   device, /color, bits_per_pixel=8, file=fileps,$
    /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *************************
; Example of the compare_spectra.dat file

;The first file (title for graph, pathname in the compare_spectra subdirectory)
;'Tisdale H2SO4 '
;tisdale.dat
;The first file (title for graph, pathname in the compare_spectra subdirectory)
;'Grainger ash'
;grainger.dat

  idat=40
  openr,idat,filnm

  header1=strarr(1)
  header2=strarr(1)

  title1=strarr(1)
  title2=strarr(1)

  file1=strarr(1)
  file2=strarr(1)

  readf,idat,header1
  readf,idat,title1
  readf,idat,file1

  readf,idat,header2
  readf,idat,title2
  readf,idat,file2

  close,idat

  file1=strcompress(dircompare+file1)
  file2=strcompress(dircompare+file2)

  print,file1
  print,file2

; *************************
  printf,iout,'  '
  printf,iout,'  compare_spectra input'

  printf,iout,'  ',header1
  printf,iout,'  ',title1
  printf,iout,'  ',file1

  printf,iout,'  ',header2
  printf,iout,'  ',title2
  printf,iout,'  ',file2

; *************************
; See wrext.pro

; wrext: bext,babs,bsca, are in 1/km units
; wrext: asym,omega are unitless
; wrext: nwave
;      160
; wrext: i,wavecm,wavelength,bext,babs,bsca,asym,omega
;  0,  2500.0000,     4.0000,  9.765e-05,  8.153e-05,

; *************************
   
   ifile1=0
   ifile2=1
    fil=strarr(1)
  for ii=ifile1,ifile2 do begin

   if (ii eq 0) then begin
    fil=file1
   endif
   if (ii eq 1) then begin
    fil=file2
   endif

; Open the ascii file
   openr,idat,fil

   for i=1,3 do begin
    readf,idat,header1
   endfor
   readf,idat,nwave
   readf,idat,header1

; wrext: i,wavecm,wavelength,bext,babs,bsca,asym,omega
;  0,  2500.0000,     4.0000,  9.765e-05,  8.153e-05,
   if (ii eq 0) then begin
     nwave1=nwave
    xvec1=fltarr(nwave)
    yvec1=fltarr(nwave)
    for i=0,nwave-1 do begin
;    readf,idat,j,wavecm,wavelength,bext,babs,bsca,asym,omega
     readf,idat,j,wavecm,wavelength,bext
     xvec1(i)=wavelength
     yvec1(i)=bext
    endfor
   endif

   if (ii eq 1) then begin
     nwave2=nwave
    xvec2=fltarr(nwave)
    yvec2=fltarr(nwave)
    for i=0,nwave-1 do begin
;    readf,idat,j,wavecm,wavelength,bext,babs,bsca,asym,omega
     readf,idat,j,wavecm,wavelength,bext
     xvec2(i)=wavelength
     yvec2(i)=bext
    endfor
   endif

  close,idat
  endfor
; Loop over the two files

; *************************
; Graph the files

   nlines=nwave1+nwave2
  xvec=fltarr(nlines)
  yvec=fltarr(nlines)
  isym=intarr(nlines)

   ii=-1
  for i=0,nwave1-1 do begin
    ii=ii+1
   xvec(ii)=xvec1(i)
   yvec(ii)=yvec1(i)
   isym(ii)=4
  endfor

  for i=0,nwave2-1 do begin
    ii=ii+1
   xvec(ii)=xvec2(i)
   yvec(ii)=yvec2(i)
   isym(ii)=6
  endfor

   labelx='Wavelength (microns)'
   labely='Extinction (km-1)'
   title=strcompress(title1+' '+title2)

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=0
    iylog=0
    ioplot=0

    graphxy,iout,xvec,yvec,isym,nlines,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

; Close the output ps graphics file
   print,' compare_indices: wrote to ',fileps
   device,/close

; *************************
  return
  end
