  pro gammasize,noprc,iout,lsetg,$
  alpha,gamma,a,b,reff,den,lrho,r1,r2,$
  ndist,radr,sized

; *****
   ndist=200
  radr=fltarr(ndist)
  radrlg=fltarr(ndist)
  sized=fltarr(ndist)

   r1lg=alog(r1)
   r2lg=alog(r2)
   dlrg=(r2lg-r1lg)/ndist
  for i=0,ndist-1 do begin
   radrlg(i)=r1lg+(i*dlrg)
   radr(i)=exp(radrlg(i))
  endfor

; See Equation of 3a of 
; Hess M, Koepke P, Shult I, Optical Properties of Aerosols and
; Clouds: The Software Package OPAC. Bull Am Met Soc 1998;79:831-844.

; sized is number of particles per cm3 per micron radii increment
  for i=0,ndist-1 do begin
   r=radr(i)
   ralpha=r^alpha
   rgamma=r^gamma
   a1=-1.00*b*rgamma
   sized(i)=den*a*ralpha*exp(a1)
  endfor

; *****
  return
  end
