  pro graphmultisets,nopr,iout,$
  npts,xvec,yvec,veccolor,isym,clrval,$
  nlines,xvecn,yvecn,igraphdat,mpts,$
  labelx,labely,title,$
  xmin,xmax,ymin,ymax,$
  x1a,y1a,x2a,y2a,$
  igrwords,grwords,xwords,ywords,wordc,$
  xr1,xr2,yr1,yr2

; ****************************
  xmin=xr1
  xmax=xr2
  ymin=yr1
  ymax=yr2

; ****************************
  xm=0.0

;  cs=1.2
;  cs2=1.5
   cs=1.1
   cs2=1.2
;  cs=1.0
;  cs2=1.0
   cthick=5.0

; *******
  plot,xvec,yvec,xtitle=labelx,ytitle=labely,title=title,$
  xrange=[xmin,xmax],$
  yrange=[ymin,ymax],$
  charsize=cs2,charthick=cthick,$
  xcharsize=cs,xthick=cs,$
  ycharsize=cs,ythick=cs,$
  thick=3,$
  xstyle=1,ystyle=1,$
  xmargin=[xm,xm],ymargin=[xm,xm],$
  position=[x1a,y1a,x2a,y2a],$
  /NODATA

; *******
; This does the lines
  for k=0,nlines-1 do begin
    xvec1=fltarr(mpts)
    yvec1=fltarr(mpts)
   for i=0,mpts-1 do begin
    xvec1(i)=xvecn(i,k)
    yvec1(i)=yvecn(i,k)
   endfor
   if (nopr eq 1) then begin
    printf,iout,'  '
    printf,iout,'  graph8linesn: k ',k  
    printf,iout,'  graph8linesn: min and max xvec1 ',min(xvec1),max(xvec1)
    printf,iout,'  graph8linesn: min and max yvec1 ',min(yvec1),max(yvec1)
   endif
   clr1=clrval(k)
   c3=cthick
   oplot,xvec1,yvec1,color=clr1,thick=c3
  endfor

; ****
; Put the two (or more) sets of data points on the graph
  if (igraphdat eq 1) then begin
  for i=0,npts-1 do begin
   x=xvec(i)
   y=yvec(i)
   c=veccolor(i)
   jsym=isym(i)

   if ((x ge xmin) and (x le xmax)) then begin
   if ((y ge ymin) and (y le ymax)) then begin
    plots,x,y,COLOR=c,PSYM=jsym,SYMSIZE=3.0,THICK=3.0,/DATA
   endif
   endif

   if ((x ge xmin) and (x le xmax)) then begin
   if ((y ge ymax) and (y le ymin)) then begin
    plots,x,y,COLOR=c,PSYM=jsym,SYMSIZE=3.0,THICK=3.0,/DATA
   endif
   endif

  endfor
  endif

; ****
; Put labels on the graph
  if (igrwords eq 1) then begin
     cth=4.0
     nsym=n_elements(xwords)
   for i=0,nsym-1 do begin
     x=xwords(i)
     y=ywords(i)
     c2=wordc(i)
    xyouts,x,y,grwords(i),CHARSIZE=cs2,COLOR=c2,/NORMAL,ALIGNMENT=0.5,$
     CHARTHICK=cth
   endfor
  endif

; *******************************
  return
  end
