   pro rd_imanaka,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Choose which temperature and rays to work with

   nfiles=3
   files=strarr(nfiles)
  files(0)='imanaka_tholins_mmc1.nc'
  files(1)='imanaka_tholins_mmc2.nc'
  files(2)='imanaka_tholins_mmc3.nc'

; ****
   print,'  Specify which Imanaka set to work with'
  for i=0,nfiles-1 do begin
   i2=i+1
   print,' iset=',i2,' ',files(i)
  endfor
  print,'  Specify iset 1,2,3'

  read,iset

   fil=strarr(1)
   fil=files(iset-1)

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnlines=ncdf_varid(nc_id,'nlines')
  ncdf_varget,nc_id,idnlines,nlines

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

; print,n70,ntext,nlines

; ****
; text=strarr(n70,ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; *****
; Read in the data
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

; ***
; Get data
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rndat
  ncdf_varget,nc_id,idri,ridat

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rd_imanaka: filnm ',filnm
    printf,iout,'  rd_imanaka: nlines ',nlines
    printf,iout,'  '
    printf,iout,'  rd_imanaka: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'   rd_imanaka: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
