   pro rdliu_soa_acp,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlinesr,wcmr,wavelengthr,rndat,$
   nlinesi,wcmi,wavelengthi,ridat,$
   ndifferent

; ***
; Note that the number of real and imaginary values are not the same
; so set ndifferent=1
   ndifferent=1

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='liu_soa_ACP2015.nc'
  filnm=strcompress(indir+fil)

  lset=strcompress(lstrn)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; netcdf liu_soa_ACP2015 {
; dimensions:
;         nlinesn = 93 ;
;         nlinesk = 571 ;
;         ntext = 10 ;
;         nlab = 9 ;
;         n70 = 70 ;
;         n60 = 60 ;
;         n8 = 8 ;
;         xsize1 = 10 ;
;         string_length1 = 72 ;
;         xsize2 = 9 ;
;         string_length2 = 60 ;
; variables:
;         short nlinesn ;
;         short nlinesk ;
;         short ntext ;
;         short n70 ;
;         short n60 ;
;         short nlab ;
;         short n8 ;
;         float wcmn(nlinesn) ;
;         float wavelengthn(nlinesn) ;
;         float wcmk(nlinesk) ;
;         float wavelengthk(nlinesk) ;
;         float rn(n8, nlinesn) ;
;         float rk(n8, nlinesk) ;
;         char text(xsize1, string_length1) ;
;         char labstr(xsize2, string_length2) ;

; ***
; Get variable ids

  idnumlinesr=ncdf_varid(nc_id,'nlinesn')
  idnumlinesi=ncdf_varid(nc_id,'nlinesk')

  idnlab=ncdf_varid(nc_id,'nlab')

  idwcmr=ncdf_varid(nc_id,'wcmn')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthn')
  idrn=ncdf_varid(nc_id,'rn')

  idwcmi=ncdf_varid(nc_id,'wcmk')
  idwavelengthi=ncdf_varid(nc_id,'wavelengthk')
  idri=ncdf_varid(nc_id,'rk')

  idntext=ncdf_varid(nc_id,'ntext')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')
  idn60=ncdf_varid(nc_id,'n60')
  idn8=ncdf_varid(nc_id,'n8')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext

  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn60,n60
  ncdf_varget,nc_id,idn8,n8

  ncdf_varget,nc_id,idnumlinesr,numlinesr
  ncdf_varget,nc_id,idnumlinesi,numlinesi

  ncdf_varget,nc_id,idnlab,nlab

  ncdf_varget,nc_id,idwcmr,wcmr2
  ncdf_varget,nc_id,idwavelengthr,wavelengthr2
  ncdf_varget,nc_id,idrn,rn

  ncdf_varget,nc_id,idwcmi,wcmi2
  ncdf_varget,nc_id,idwavelengthi,wavelengthi2
  ncdf_varget,nc_id,idri,ri

   text=strarr(ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

   labstr=strarr(nlab)
  idlabstr=ncdf_varid(nc_id,'labstr')
  ncdf_varget,nc_id,idlabstr,labstr
  labstr=string(labstr)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
    print,'  '
    print,'  choose ilab from 1 to 8'
   for i=0,nlab-1 do begin
    print,'  ',labstr(i)
   endfor

   read,ilab
   ilab=fix(ilab)
   print,'  will use ilab ',ilab,'  ',labstr(ilab-1)

; **
    nlinesr=fix(numlinesr)
    nlinesi=fix(numlinesi)

    rndat=fltarr(nlinesr)
    ridat=fltarr(nlinesi)
    wcmr=fltarr(nlinesr)
    wcmi=fltarr(nlinesi)
    wavelengthr=fltarr(nlinesr)
    wavelengthi=fltarr(nlinesi)

; **
; Specify the output values

   j=ilab-1
   for i=0,nlinesr-1 do begin
    rndat(i)=rn(i,j)
    wcmr(i)=wcmr2(i)
    wavelengthr(i)=wavelengthr2(i)
   endfor

   for i=0,nlinesi-1 do begin
    ridat(i)=ri(i,j)
    wcmi(i)=wcmi2(i)
    wavelengthi(i)=wavelengthi2(i)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdliou_soa_acp: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,'  ',text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdliou_soa_acp: ilab, labstr(ilab-1)'
   printf,iout,'  ',ilab,'  ',labstr(ilab-1)
   printf,iout,'  rdliou_soa_acp: i,wcmr,wavelengthr,rndat'
   for i=0,nlinesr-1 do begin
    printf,iout,'  ',i,wcmr(i),wavelengthr(i),rndat(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdliou_soa_acp: i,wcmi,wavelengthi,ridat'
   for i=0,nlinesi-1 do begin
    printf,iout,'  ',i,wcmi(i),wavelengthi(i),ridat(i)
   endfor

  endif

; ******
  return
  end
