   pro rdmyhre_organic_acids,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='myhre_organic_acids.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlinesmax=ncdf_varid(nc_id,'nlinesmax')
  idncases=ncdf_varid(nc_id,'ncases')
  idnumlines=ncdf_varid(nc_id,'numlines')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthr')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idnlinesmax,nlinesmax
  ncdf_varget,nc_id,idnumlines,numlines
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idwcm,wcm2
  ncdf_varget,nc_id,idwavelengthr,wavelengthr
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
; Specify the set to work with
  print,' iset=1,2,3,4,5 for Oxalic, Malonic, Succinc, Glutaric, Pyruvic'  
  print,' specify iset '
  read,iset

  jimag=-99
  jreal=-99
  text2=strarr(1)

; For Oxalic
  if (iset eq 1) then begin
   print,' Oxalic acid is 10 or 5 wt%'
   print,' specify wt% (10 or 5)'
   read,wt
   if (wt eq 10) then begin
    jreal=13
    jimag=15
    text2='Oxalic 10 wt%'
   endif
   if (wt eq 5) then begin
    jreal=14
    jimag=15
    text2='Oxalic 5 wt%'
   endif
  endif

; For Malonic
  if (iset eq 2) then begin
   print,' Malonic acid is 10, 25, or 60 wt%'
   print,' specify wt% (10, 25, or 60)'
   read,wt
   if (wt eq 10) then begin
    jreal=9
    jimag=12
    text2='Malonic 10 wt%'
   endif
   if (wt eq 25) then begin
    jreal=10
    jimag=12
    text2='Malonic 25 wt%'
   endif
   if (wt eq 60) then begin
    jreal=11
    jimag=12
    text2='Malonic 60 wt%'
   endif
  endif

; For Succinc
  if (iset eq 3) then begin
   print,' Succinc acid '
   print,' wt=8%'
    jreal=20
    jimag=21
    text2='Succinc 8 wt%'
  endif

; For Malonic
  if (iset eq 4) then begin
   print,' Glutaric acid is 5, 25, or 50 wt%'
   print,' specify wt% (5, 25, or 50)'
   read,wt
   if (wt eq 5) then begin
    jreal=6
    jimag=7
    text2='Glutaric 5 wt%'
   endif
   if (wt eq 25) then begin
    jreal=4
    jimag=7
    text2='Glutaric 25 wt%'
   endif
   if (wt eq 50) then begin
    jreal=5
    jimag=7
    text2='Glutaric 50 wt%'
   endif
  endif

; For Pyruvic
  if (iset eq 5) then begin
   print,' Pyruvic acid '
   print,' wt=5%'
    jreal=18
    jimag=19
    text2='Pyruvic 5 wt%'
  endif

; *****
; text string indexing and the program used to produced the files differs by 2
; The first set is ammoniumsulfate, imaginary indices, for "ifile=0" in
; the program that wrote out to the netCDF file
  jimag=jimag-2
  jreal=jreal-2
  icase=jimag

; *****
; Check and stop
  if ((jimag lt 0) or (jreal lt 0)) then begin
   print,'  rdmyhre_organic_acids: index set not specified correctly'
   print,'  iset and wt should be integers'
   stop
  endif

; *****
; Note that you only read in the data for which the real and imaginary
; parts are both specified
    nlines=fix(numlines(icase))
   rndat=fltarr(nlines)
   ridat=fltarr(nlines)
   wcm=fltarr(nlines)
   wavelength=fltarr(nlines)

; **
; Specify the output values
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,jreal)
    ridat(i)=ri(i,jimag)
    wcm(i)=wcm2(i,icase)
    wavelength(i)=wavelengthr(i,icase)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+text2)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdmyhre_organic_acids: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdmyhre_organic_acids: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


