   pro rdmyhre_ternary,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='myhre_ternary.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnumlinesr=ncdf_varid(nc_id,'numlinesr')
  idnumlinesi=ncdf_varid(nc_id,'numlinesi')
  idncases=ncdf_varid(nc_id,'ncases')
  idntempmax=ncdf_varid(nc_id,'ntempmax')
  idwh2so4=ncdf_varid(nc_id,'wh2so4')
  idwhno3=ncdf_varid(nc_id,'whno3')
  idwh2o=ncdf_varid(nc_id,'wh2o')
  idtemps=ncdf_varid(nc_id,'temps')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idwcmr=ncdf_varid(nc_id,'wcmr')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthr')
  idrn=ncdf_varid(nc_id,'rn')
  idwcmi=ncdf_varid(nc_id,'wcmi')
  idwavelengthi=ncdf_varid(nc_id,'wavelengthi')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnumlinesr,numlinesr
  ncdf_varget,nc_id,idnumlinesi,numlinesi
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idwh2so4,wh2so4
  ncdf_varget,nc_id,idwhno3,whno3
  ncdf_varget,nc_id,idwh2o,wh2o
  ncdf_varget,nc_id,idntempmax,ntempmax
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcmr,wcmr
  ncdf_varget,nc_id,idwavelengthr,wavelengthr
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idwcmi,wcmi
  ncdf_varget,nc_id,idwavelengthi,wavelengthi
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
  iadd=2
  print,' icase=0 ',text(2)
  print,' icase=1 ',text(3)
  print,' icase=2 ',text(4)

  print,' specify icase 0,1,2 '
  read,icase

  iicase=icase+iadd

  nt=ntemps(icase)
  vec=fltarr(nt)
  for i=0,nt-1 do begin
   vec(i)=temps(icase,i)
  endfor
  print,' will specify temp in kelvin from this listing'
  print,'  ',vec

  print,' specify temp in kelvin'
  read,temp

; *****
    diffmin=1.0e6
    jtemp=-99
   for j=0,nt-1 do begin
     diff=abs(temp-temps(icase,j))
    if (diff lt diffmin) then begin  
     jtemp=j
     diffmin=diff
    endif
   endfor

; **
     nlines=fix(numlinesr(icase))
     numr=fix(numlinesr(icase))
     numi=fix(numlinesr(icase))
    if (numr ne numi) then begin
     print,'  '
     print,'  rdmyhre_ternary: numr,numi ',numr,numi 
     print,'  rdmyhre_ternary: numr ne numi, will stop'
     stop
    endif

    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)

    print,'  '
    print,'  rdmyhre_ternary: icase,text(iicase) ',icase,text(iicase)
    print,'  rdmyhre_ternary: nlines,temp,jtemp,temps(icase,jtemp)
    print,'  ',nlines,temp,jtemp,temps(icase,jtemp)

    print,iout,'  '
    print,iout,'  rdmyhre_ternary: icase,text(iicase) ',icase,text(iicase)
    print,iout,'  rdmyhre_ternary: nlines,temp,jtemp,temps(icase,jtemp)
    print,iout,'  ',nlines,temp,jtemp,temps(icase,jtemp)

; **
; Specify the output values
; wcmr and wcmi are the same 
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,icase,jtemp)
    ridat(i)=ri(i,icase,jtemp)
    wcm(i)=wcmr(i,icase)
    wavelength(i)=wavelengthr(i,icase)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+text(iicase))

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdmyhre_ternary: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdmyhre_ternary: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


