   pro rdtoon_mont_granite,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='toon_mont_granite.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idngranite=ncdf_varid(nc_id,'ngranite')
  idnmont219=ncdf_varid(nc_id,'nmont219')
  idnmont222=ncdf_varid(nc_id,'nmont222')

  idwcmgranite=ncdf_varid(nc_id,'wcmgranite')
  idwcmmont219=ncdf_varid(nc_id,'wcmmont219')
  idwcmmont222=ncdf_varid(nc_id,'wcmmont222')

  idwmicgranite=ncdf_varid(nc_id,'wmicgranite')
  idwmicmont219=ncdf_varid(nc_id,'wmicmont219')
  idwmicmont222=ncdf_varid(nc_id,'wmicmont222')

  idrngranite=ncdf_varid(nc_id,'rngranite')
  idrnmont219=ncdf_varid(nc_id,'rnmont219')
  idrnmont222=ncdf_varid(nc_id,'rnmont222')

  idrigranite=ncdf_varid(nc_id,'rigranite')
  idrimont219=ncdf_varid(nc_id,'rimont219')
  idrimont222=ncdf_varid(nc_id,'rimont222')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idngranite,ngranite
  ncdf_varget,nc_id,idnmont219,nmont219
  ncdf_varget,nc_id,idnmont222,nmont222

  ncdf_varget,nc_id,idwcmgranite,wcmgranite
  ncdf_varget,nc_id,idwcmmont219,wcmmont219
  ncdf_varget,nc_id,idwcmmont222,wcmmont222

  ncdf_varget,nc_id,idwmicgranite,wmicgranite
  ncdf_varget,nc_id,idwmicmont219,wmicmont219
  ncdf_varget,nc_id,idwmicmont222,wmicmont222

  ncdf_varget,nc_id,idrngranite,rngranite
  ncdf_varget,nc_id,idrnmont219,rnmont219
  ncdf_varget,nc_id,idrnmont222,rnmont222

  ncdf_varget,nc_id,idrigranite,rigranite
  ncdf_varget,nc_id,idrimont219,rimont219
  ncdf_varget,nc_id,idrimont222,rimont222

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Specify which set to work with
  print,'  Toon minerals'
  print,'  iset=0,1,2 for granite, montmorillonite 219, montmorillonite 222'
  print,'  Specify iset'

  read,iset

  lines2=intarr(3)
  lines2(0)=ngranite
  lines2(1)=nmont219
  lines2(2)=nmont222

  nlines=intarr(1)
  nlines=lines2(iset)
  i1=0
  i2=nlines(0)-1
  nlines=i2+1

  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)

; **
  if (iset eq 0) then begin
   for i=i1,i2 do begin
    rndat(i)=rngranite(i)
    ridat(i)=rigranite(i)
    wcm(i)=wcmgranite(i)
    wavelength(i)=wmicgranite(i)
   endfor
   casestr=' granite '
   goto,jump1
  endif

  if (iset eq 1) then begin
   for i=i1,i2 do begin
    rndat(i)=rnmont219(i)
    ridat(i)=rimont219(i)
    wcm(i)=wcmmont219(i)
    wavelength(i)=wmicmont219(i)
   endfor
   casestr=' montmorillionite 219b'
   goto,jump1
  endif

  if (iset eq 2) then begin
   for i=i1,i2 do begin
    rndat(i)=rnmont222(i)
    ridat(i)=rimont222(i)
    wcm(i)=wcmmont222(i)
    wavelength(i)=wmicmont222(i)
   endfor
   casestr=' montmorillionite 222b'
   goto,jump1
  endif

  jump1:mn=0

; ***
   lset=strcompress(lstrn+casestr)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdtoon_mont_granite: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdtoon_mont_granite: i,wcm,wavelength,rndat and ridat'
   for i=i1,i2 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


