  pro test3,nopr,$
  iout,indir,outdir,fout

; *****
; The output ps graphics file
  fileps=strcompress(outdir+'test3.ps')

  printf,iout,'  test1: ',fileps

; *****
; Open the output ps file
  set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *****
; Specify the indices to work with

; Water indices
  iset=0
; Don't graph the input indices
  igraphi=0 

; *****
; Read in the listing of refractive index sets
; from the   indices.dat  ascii listing
    noprlist=0
   rdlistrn,noprlist,iout,$
   nsets,listrn

; *****
; Do the calculations on a wavelength scale
   iwave=2

; Specify w1,w2,dw values (range of wavenumber,wavenumber spacing in spectra
; or range of wavelength in microns, wavelength spacing in spectra in microns)
  w1=4.0
  w2=12.0
  dw=0.05

; *****
; To write out the indices to the output ascii and netCDF files put iwrind=1
  iwrind=1

; Read in the indices
    noprind=1
   rdindices,noprind,iout,$
   indir,$
   iset,igraphi,$
   nsets,listrn,lstrn,$
   nlines,wcm,wavelength,rndat,ridat,$
   outdir,iwave,iwrind,lset,ibothpos

   lsetorig=lset

; *****
; Obtain the wavenumber (or wavelength) scale
; Will use interpolation to obtain rn and ri indices
   noprwave=1
  calcwave,noprwave,iout,$
  nlines,wcm,wavelength,rndat,ridat,$
  iwave,w1,w2,dw,$
  nwave,wave,rn,ri,$
  outdir,igraphi,iwrind,lset,lstrn,$
  ibothpos

; *****
; Loop over a set of size distributions
   ngr=4
  igr1=0
  igr2=ngr-1
  nlast=igr2+1

  dens=fltarr(ngr)
  rads=fltarr(ngr)
  sigs=fltarr(ngr)
   den2=0.0
   rad2=0.0
   sig2=0.0
  sigs=[1.1,1.5,2.0,3.0]
   lsetadd=strarr(ngr)
  for i=0,ngr-1 do begin
   dens(i)=1.0e-2
   rads(i)=0.1
   lsetadd(i)=strcompress(string(sigs(i)))
  endfor

; ***
; Loop over the size distributions
   noprsize=0
   noprext=0
   igraphd=0
   iwrsize=0
   iwrext=0
   igraphe=1
   ngraph=0
  for ii=igr1,igr2 do begin

   print,'  ii ',ii

; Specify the radii range r1,r2 of the size distribution in microns
   r1=0.005
   r2=3.0

; Specify the log-normal size distribution parameters
   den1=dens(ii)
   rad1=rads(ii)
   sig1=sigs(ii)

   lset=strcompress(lsetorig+lsetadd(ii))

   printf,iout,'  '
   printf,iout,'  test3: ii,den1,rad1,sig1'
   printf,iout,'  ',ii,den1,rad1,sig1
   printf,iout,'  test3: lset ',lset

   calcsized,noprsize,iout,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   outdir,igraphd,iwrsize,$
   lset

; ***
; Calculate the spectra (extinction, absorption, scattering, single scattering
; albedo, and asymmetry parameter)
   calcext,noprext,iout,$
   iwave,nwave,wave,rn,ri,$
   ndist,radr,sized,$
   bext,babs,bsca,asym,back,omega,$
   outdir,igraphe,iwrext,lset,$
   ngraph,nlast

  endfor

  stop

; *****
  return
  end
