  pro maxwell,iout,m1,m2,f2,m3

;-----------------------------------------------------------
;
; routine uses the Maxwell-Garnet relation to 
; find the refractive index of a mixture of two substances.
;
; Input:
;   m1......complex refractive index of substance 1
;   m2......complex refractive index of substance 2
;   f2......volume fraction of substance 2
;
; Output:
;   m3......complex refractive index of mixture
;
; source:  Mark Hervig
;
;-----------------------------------------------------------

;- dialectric function e = index^2
   e1   = m1^2
   e2   = m2^2

;- Maxwell-Garnet (1904)
   term   = (e2-e1)/(e2+2.*e1)
   e3     = e1*( 1.+ (3.*f2*term)/(1.-f2*term) )

; The refractive index of the mixture
   m3 = sqrt(e3)

; ****
   return
   end

