   pro rdchang_flame_soot,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
   lset=strcompress(lstrn)

; ***
; The input netCDF file
  fil=strarr(1)
  fil='chang_flame_soot.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idnheight=ncdf_varid(nc_id,'nheight')
  idwcmflame=ncdf_varid(nc_id,'wcmflame')
  idwmicflame=ncdf_varid(nc_id,'wmicflame')
  idrn=ncdf_varid(nc_id,'rnflame')
  idri=ncdf_varid(nc_id,'riflame')
  idheight=ncdf_varid(nc_id,'height')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idnheight,nheight
  ncdf_varget,nc_id,idheight,height
  ncdf_varget,nc_id,idwcmflame,wcmflame
  ncdf_varget,nc_id,idwmicflame,wmicflame
  ncdf_varget,nc_id,idrn,rnflame
  ncdf_varget,nc_id,idri,riflame

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

  nlines=nwave

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  chang flame soot as a function of height above the flame'
  print,'  specify flame height in mm (6, 8, or 10 mm)'
  read,heightmm

   diffmin=1.0e6
   j=-99
  for i=0,2 do begin
    diff=abs(heightmm-height(i))
   if (diff lt diffmin) then begin
    j=i
    diffmin=diff
   endif
  endfor

  print,'  rdchang_flame_soot: heightmm,j,height(j) ',heightmm,j,height(j)

; *****
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
    wcm=fltarr(nwave)
    wavelength=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rnflame(i,j)
    ridat(i)=riflame(i,j)
    wcm(i)=wcmflame(i)
    wavelength(i)=wmicflame(i)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdchang_flame_soot: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdchang_flame_soot: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


