   pro rdhenning_sio2_lowtemp,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Choose which temperature to work with
; ****
  print,'  Specify which Henning and Mutschke SiO2 low temperture set '
  print,'  iset 1   10 K '
  print,'  iset 2   100 K '
  print,'  iset 3   200 K '
  print,'  iset 4   300 K '
  print,'  Specify iset  1,2,3 or 4'

  read,iset

   fil=strarr(1)
  if (iset eq 1) then begin
   fil='henning_mutschke_sio2_10K.nc'
  endif
  if (iset eq 2) then begin
   fil='henning_mutschke_sio2_100K.nc'
  endif
  if (iset eq 3) then begin
   fil='henning_mutschke_sio2_200K.nc'
  endif
  if (iset eq 4) then begin
   fil='henning_mutschke_sio2_300K.nc'
  endif

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnlines=ncdf_varid(nc_id,'nlines')
  ncdf_varget,nc_id,idnlines,nlines

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

; print,n70,ntext,nlines

; ****
; text=strarr(n70,ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; *****
; Read in the data
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

; ***
; Get data
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rndat
  ncdf_varget,nc_id,idri,ridat

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdhenning: filnm ',filnm
    printf,iout,'  rdhenning_sio2_lowtemp: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'   rdhenning_sio2_lowtemp: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
