   pro rdkou,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='kou_imag_water_ice.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnwater22=ncdf_varid(nc_id,'nwater22')
  idnwaterm8=ncdf_varid(nc_id,'nwaterm8')
  idnicem25=ncdf_varid(nc_id,'nicem25')

  idwcmwater22=ncdf_varid(nc_id,'wcmwater22')
  idwcmwaterm8=ncdf_varid(nc_id,'wcmwaterm8')
  idwcmicem25=ncdf_varid(nc_id,'wcmicem25')

  idwmicwater22=ncdf_varid(nc_id,'wmicwater22')
  idwmicwaterm8=ncdf_varid(nc_id,'wmicwaterm8')
  idwmicicem25=ncdf_varid(nc_id,'wmicicem25')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

  idriwater22=ncdf_varid(nc_id,'riwater22')
  idriewater22=ncdf_varid(nc_id,'riewater22')

  idriwaterm8=ncdf_varid(nc_id,'riwaterm8')
  idriewaterm8=ncdf_varid(nc_id,'riewaterm8')

  idriicem25=ncdf_varid(nc_id,'riicem25')
  idrieicem25=ncdf_varid(nc_id,'rieicem25')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idnwater22,nwater22
  ncdf_varget,nc_id,idnwaterm8,nwaterm8
  ncdf_varget,nc_id,idnicem25,nicem25

  ncdf_varget,nc_id,idwcmwater22,wcmwater22
  ncdf_varget,nc_id,idwcmwaterm8,wcmwaterm8
  ncdf_varget,nc_id,idwcmicem25,wcmicem25

  ncdf_varget,nc_id,idwmicwater22,wmicwater22
  ncdf_varget,nc_id,idwmicwaterm8,wmicwaterm8
  ncdf_varget,nc_id,idwmicicem25,wmicicem25

  ncdf_varget,nc_id,idriwater22,riwater22
  ncdf_varget,nc_id,idriwaterm8,riwaterm8
  ncdf_varget,nc_id,idriicem25,riicem25

  ncdf_varget,nc_id,idriewater22,riewater22
  ncdf_varget,nc_id,idriewaterm8,riewaterm8
  ncdf_varget,nc_id,idrieicem25,rieicem25

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Ask which set to work with
   print,' rdkou: note that kou only gives the imaginary indices'
   print,' Specify the temperature itemp to work work with (22, -8, or -25) C '
   read,itemp

   if (itemp eq 22) then begin
    nlines=nwater22
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)
    for i=0,nlines-1 do begin
     wavelength(i)=wmicwater22(i)
     wcm(i)=wcmwater22(i)
     rndat(i)=0.0
     ridat(i)=riwater22(i)
    endfor
    text2=' -22 C water'
   endif

   if (itemp eq -8) then begin
    nlines=nwaterm8
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)
    for i=0,nlines-1 do begin
     wavelength(i)=wmicwaterm8(i)
     wcm(i)=wcmwaterm8(i)
     rndat(i)=0.0
     ridat(i)=riwaterm8(i)
    endfor
    text2=' -8 C water'
   endif

   if (itemp eq -25) then begin
    nlines=nwaterm25
    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)
    for i=0,nlines-1 do begin
     wavelength(i)=wmicwaterm25(i)
     wcm(i)=wcmwaterm25(i)
     rndat(i)=0.0
     ridat(i)=riicem25(i)
    endfor
    text2=' -25 C ice'
   endif

; ****
  lset=strcompress(lstrn+text2)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdkou: note that kou only gives the imaginary indices'

    printf,iout,'  '
    printf,iout,'  rdkou: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdkou: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
