   pro rdquerry_diesel_soot,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  fil=strarr(1)
  fil='querry_diesel_soot.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
  idnwav1=ncdf_varid(nc_id,'nwav1')
  ncdf_varget,nc_id,idnwav1,nwav1

  idnwav2=ncdf_varid(nc_id,'nwav2')
  ncdf_varget,nc_id,idnwav2,nwav2

  idnwav3=ncdf_varid(nc_id,'nwav3')
  ncdf_varget,nc_id,idnwav3,nwav3

  idnwav4=ncdf_varid(nc_id,'nwav4')
  ncdf_varget,nc_id,idnwav4,nwav4

  idntext=ncdf_varid(nc_id,'ntext')
  ncdf_varget,nc_id,idntext,ntext

  idn70=ncdf_varid(nc_id,'n70')
  ncdf_varget,nc_id,idn70,n70

; print,n70,ntext,nwav1,nwav2,nwav3,nwav4

; ****
; text=strarr(n70,ntext)
  idtext=ncdf_varid(nc_id,'text')
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
  print,'  Specify which set to work with '
  print,'  iset 1   Querry 1987 Diesel Soot - NMSU unheated '
  print,'  iset 2   Querry 1987 Diesel Soot - UMKC Querry '
  print,'  iset 3   Querry 1987 Diesel Soot - NMSU heated '
  print,'  iset 4   Querry 1987 Diesel Soot - Felske '
  print,'  Specify iset  1,2,3,4'

  read,iset

; *****
; Read in the data

  if (iset eq 1) then begin
   nlines=nwav1
   idwcm=ncdf_varid(nc_id,'wn1')
   idwavelength=ncdf_varid(nc_id,'wl1')
   idrn=ncdf_varid(nc_id,'rn1')
   idri=ncdf_varid(nc_id,'ri1')
  endif

  if (iset eq 2) then begin
   nlines=nwav2
   idwcm=ncdf_varid(nc_id,'wn2')
   idwavelength=ncdf_varid(nc_id,'wl2')
   idrn=ncdf_varid(nc_id,'rn2')
   idri=ncdf_varid(nc_id,'ri2')
  endif

  if (iset eq 3) then begin
   nlines=nwav3
   idwcm=ncdf_varid(nc_id,'wn3')
   idwavelength=ncdf_varid(nc_id,'wl3')
   idrn=ncdf_varid(nc_id,'rn3')
   idri=ncdf_varid(nc_id,'ri3')
  endif

  if (iset eq 4) then begin
   nlines=nwav4
   idwcm=ncdf_varid(nc_id,'wn4')
   idwavelength=ncdf_varid(nc_id,'wl4')
   idrn=ncdf_varid(nc_id,'rn4')
   idri=ncdf_varid(nc_id,'ri4')
  endif

; ***
; Get data
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rndat
  ncdf_varget,nc_id,idri,ridat

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdquerry_diesel_soot: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdquerry_diesel_soot: will work with Composition ',iset

   printf,iout,'  '
   printf,iout,'  rdquerry_diesel_soot: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
